### -*- coding: utf-8 -*- ####################################################
##############################################################################
#
# Copyright (c) 2012 Thierry Florac <tflorac AT ulthar.net>
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.1 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE.
#
##############################################################################


# import standard packages
from persistent import Persistent

# import Zope3 interfaces

# import local interfaces

# import Zope3 packages
from zope.container.contained import Contained
from zope.interface import implements
from zope.schema.fieldproperty import FieldProperty

# import local packages
from ztfy.geoportal.interfaces import IGeoportalConfigurationUtility


class GeoportalConfigurationUtility(Persistent, Contained):
    """Geoportal configuration utility"""

    implements(IGeoportalConfigurationUtility)

    api_key = FieldProperty(IGeoportalConfigurationUtility['api_key'])
    version = FieldProperty(IGeoportalConfigurationUtility['version'])
    development = FieldProperty(IGeoportalConfigurationUtility['development'])
