from pathlib import Path


class Files:
    """
    This class encapsulates the file system for librec-auto.

    The files for librec-auto can be stored in a number of possible locations:
    - global location: determined by the install location of librec-auto
    - rules-specific location: determined by the location of a rules directory [Not implemented]
    - user-specific location: associated with the user's home directory [Not implemented]
    - experiment-specific location: in a directory associated with a specific experiment.

    These are the types of files that are managed:
    - configuration files (XML). Stores information about how experiments are configured.
    - properties files (key=value format). Generated from configuration files for input to librec
    - split files (UIR or UIRT format). Generated by separating input rules files into different test/training splits
    - experiment logs (csv files). Content is algorithm-specific. Generated by a run of an experiment

    NOTE: User directory is currently unused.
    """

    # _DEFAULT_GLOBAL_DIR_STR = inspect.getfile(fair_dynamic_rec)

    _DEFAULT_CONFIG_DIR_NAME = "conf"
    # _DEFAULT_RES_DIR_NAME = "result"
    # _DEFAULT_DATA_DIR_NAME = "data"
    # _DEFAULT_POST_DIR_NAME = "post"
    # _DEFAULT_LIBRARY_DIR_NAME = "lib"
    # _EXP_DIR_FORMAT = "exp{:05d}"
    # _EXP_DIR_PATTERN = "exp(\d+)"
    # _OUTPUT_FILE_NAME = "output.xml"

    DEFAULT_CONFIG_FILENAME = "config.xml"
    # DEFAULT_REF_EXP_FILENAME = "ref_exp.txt"
    # DEFAULT_TRAIN_FILENAME = "train.txt"
    # DEFAULT_TEST_FILENAME = "test.txt"

    # _DEFAULT_SPLIT_DIR_NAME = "split"

    def __init__(self):
        self._config_dir_path = Path(self._DEFAULT_CONFIG_DIR_NAME)
        # self._data_dir_path = Path(self._DEFAULT_DATA_DIR_NAME)
        # self._jar_dir_path = Path(self._DEFAULT_JAR_DIR_NAME)
        # self._post_dir_path = Path(self._DEFAULT_POST_DIR_NAME)
        # self._lib_dir_path = Path(self._DEFAULT_LIBRARY_DIR_NAME)
        # self._exp_path_dict = OrderedDict()
        #
        #
        # module_init_path = Path(Files._DEFAULT_GLOBAL_DIR_STR).parent
        # self._global_path = module_init_path.parent
        #
        # self._split_dir_path = Path(self._DEFAULT_SPLIT_DIR_NAME)

    # Paths related to the librec installation
    # def get_global_path(self):
    #     return self._global_path
    #
    # def set_global_path(self, path):
    #     self._global_path = Path(path)
    #
    # def get_data_path(self):
    #     return self.get_study_path() / self._data_dir_path
    #
    # def set_data_path(self, config_xml):
    #     data_dir_elem = single_xpath(config_xml, '/librec-auto/data/data-dir')
    #     if data_dir_elem is None:
    #         logging.warning("Configuration file missing data-dir element. Assuming 'data'.")
    #     else:
    #         self._data_dir_path = data_dir_elem.text
    #
    # def get_rules_path(self):
    #     return self.get_global_path() / self._DEFAULT_RULES_FILE
    #
    # def get_lib_path(self):
    #     return self.get_global_path() / self._DEFAULT_LIB_DIR_NAME
    #
    # def get_jar_path(self):
    #     return self.get_global_path() / self._jar_dir_path
    #
    # def get_classpath(self):
    #     return (self.get_jar_path() /
    #             self._DEFAULT_LA_JAR).absolute().as_posix()
    #
    # # Paths related to the current study
    # def get_study_path(self):
    #     return self._study_path
    #
    # def get_status_path(self):
    #     return self._study_path / self._OUTPUT_FILE_NAME

    def get_config_file_path(self):
        return self._study_path / self._config_dir_path / self._config_file_name

    # def get_config_dir_path(self):
    #     return self._study_path / self._config_dir_path
    #
    # def set_post_path(self, path):
    #     self._post_dir_path = Path(path)
    #
    # def get_post_path(self):
    #     return self._study_path / self._post_dir_path
    #
    # def get_split_path(self):
    #     return self._data_dir_path / self._split_dir_path

    def set_study_path(self, path):
        self._study_path = Path(path)

    def set_config_file(self, filename):
        self._config_file_name = Path(filename)
