import { CfnTag, IResolvable } from 'aws-cdk-lib';
import { CfnDocument } from 'aws-cdk-lib/aws-ssm';
import { Construct } from 'constructs';
import { DocumentOutput } from '../domain/document-output';
import { Input } from '../domain/input';
import { IStringVariable } from '../interface/variables/string-variable';
export declare enum DocumentFormat {
    JSON = 0,
    YAML = 1
}
export interface SsmDocumentProps {
    /**
       * (Optional) Name of the document. Will default to the id provided for the CDK node.
       */
    readonly documentName?: string;
    /**
       * (Optional) Description of the document. Defaults to the document name.
       */
    readonly description?: string;
    /**
       * (Optional) A Header/comment to include at the start of a YAML document. JSON documents do not support headers.
       */
    readonly header?: string;
    /**
       * (Optional) Assume role to use for this document.
       * If provided, this value MUST be included as one of the documentInput names.
       */
    readonly assumeRole?: IStringVariable;
    /**
       * (Optional) Outputs to be emitted from the document.
       * The outputs are placed in a StringSet called outputs (as is done in SSM).
       * @default []
       */
    readonly docOutputs?: DocumentOutput[];
    /**
       * (Optional) Inputs required by the document.
       */
    readonly docInputs?: Input[];
    /**
       * (Optional) Specifies whether this document should be written as YAML or JSON.
       * @default JSON
       */
    readonly documentFormat?: DocumentFormat;
    /**
       * `AWS::SSM::Document.Requires`.
       *
       * @external
       * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-requires
       */
    readonly requires?: Array<CfnDocument.DocumentRequiresProperty | IResolvable> | IResolvable;
    /**
       * `AWS::SSM::Document.Tags`.
       *
       * @external
       * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-tags
       */
    readonly tags?: CfnTag[];
    /**
       * `AWS::SSM::Document.TargetType`.
       *
       * @external
       * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-targettype
       */
    readonly targetType?: string;
    /**
     * If the document resource you specify in your template already exists, this parameter determines whether a new version of the existing document is created, or the existing document is replaced. `Replace` is the default method. If you specify `NewVersion` for the `UpdateMethod` parameter, and the `Name` of the document does not match an existing resource, a new document is created. When you specify `NewVersion` , the default version of the document is changed to the newly created version.
     *
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-updatemethod
     */
    readonly updateMethod?: string;
    /**
       * `AWS::SSM::Document.VersionName`.
       *
       * @external
       * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ssm-document.html#cfn-ssm-document-versionname
       */
    readonly versionName?: string;
}
export declare abstract class SsmDocument extends Construct {
    readonly documentName: string;
    readonly description: string;
    readonly header?: string;
    readonly assumeRole?: IStringVariable;
    readonly docOutputs: DocumentOutput[];
    readonly docInputs: Input[];
    readonly props: SsmDocumentProps;
    readonly cfnDocument: CfnDocument;
    constructor(scope: Construct, id: string, props: SsmDocumentProps);
    /**
     * The SSM Document inputs optionally specify a number of parameters including allowedValues, minItems etc.
     * This function builds an object containing the relevant (declared) input parameters.
     * The return object will be used to build the yaml/json representation of the document.
     */
    protected formatInputs(): {
        [name: string]: any;
    };
    abstract documentType(): string;
    /**
       * Delegates building the SSM Document to be converted to a yaml/json to the subclass (Automation etc).
       */
    protected abstract buildSsmDocument(): {
        [name: string]: any;
    };
    /**
       * Synthesize before calling this function!
       * You can use this to Synthesize: cdk.SynthUtils.synthesize(stack);
       *
       * Converts the objects define in the SSM Document (including all of the steps) to an SSM document string.
       * The format is dependency on the documentFormat property provided to the class.
       * The yaml can be used as is and will behave (or at least should behave) as was simulated in the runSimulation().
       * @returns a string representation of this document as an SSM formatted yaml/json.
       */
    print(): string;
    /**
       * Prepend header line with # if it does not start with #.
       * If no header is provided, this method will return an emptry string.
       * Headers are only available in yaml format.
       */
    private headerWithComments;
}
