/**
 * DataTypes as supported by SSM Documents.
 */
export declare enum DataTypeEnum {
    STRING = 0,
    INTEGER = 1,
    BOOLEAN = 2,
    STRING_LIST = 3,
    STRING_MAP = 4,
    MAP_LIST = 5
}
/**
 * JSII does not allow functions or constants declared in an enum class directly.
 * Therefore, interaction with DataTypeEnum happens through this class.
 */
export declare class DataType {
    static fromDataType(ssmDataType: string): DataType;
    private static readonly STRING_TO_DATA_TYPE;
    readonly dataTypeEnum: DataTypeEnum;
    constructor(dataTypeEnum: DataTypeEnum);
    /**
       * @returns the SSM string representation of this DataType
       */
    toSsmString(): string;
    /**
       * @returns true if the input variable matches the associated dataTypeEnum
       */
    validateType(val: any): boolean;
}
