"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.isNumber = exports.assertNumber = exports.NumberVariable = exports.HardCodedNumber = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const variable_1 = require("./variable");
/**
 * A hard-coded number variable.
 * Used when not dependent on step inputs.
 */
class HardCodedNumber extends variable_1.HardCodedValueBase {
    static of(val) {
        return new HardCodedNumber(val);
    }
    resolveToNumber(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertNumber(value);
    }
}
exports.HardCodedNumber = HardCodedNumber;
_a = JSII_RTTI_SYMBOL_1;
HardCodedNumber[_a] = { fqn: "@cdklabs/cdk-ssm-documents.HardCodedNumber", version: "0.0.34" };
/**
 * A number variable reference.
 * Used to resolve the value from step inputs.
 */
class NumberVariable extends variable_1.GenericVariable {
    static of(reference) {
        return new NumberVariable(reference);
    }
    resolveToNumber(inputs) {
        return this.resolve(inputs);
    }
    assertType(value) {
        assertNumber(value);
    }
}
exports.NumberVariable = NumberVariable;
_b = JSII_RTTI_SYMBOL_1;
NumberVariable[_b] = { fqn: "@cdklabs/cdk-ssm-documents.NumberVariable", version: "0.0.34" };
/**
 * Assert that the given value is a NullableNumber.
 * @param value value to assert
 */
function assertNumber(value) {
    if (!isNumber(value)) {
        throw new Error(`${value} is not a number`);
    }
}
exports.assertNumber = assertNumber;
/**
 * Whether the given value is a NullableNumber.
 * @param value value to check
 * @returns true if the value is a NullableNumber, otherwise false
 */
function isNumber(value) {
    if (value === null) {
        return true;
    }
    return typeof value === 'number' || value instanceof Number;
}
exports.isNumber = isNumber;
//# sourceMappingURL=data:application/json;base64,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