import { Construct } from 'constructs';
import { Platform } from '../../domain/platform';
import { IStringVariable } from '../../interface/variables/string-variable';
import { CommandStep, CommandStepProps } from '../command-step';
/**
 * Properties for ps Module step.
 */
export interface PsModuleStepProps extends CommandStepProps {
    /**
       * Specify the commands to run or the path to an existing script on the instance.
       */
    readonly runCommand?: IStringVariable[];
    /**
       * The URL or local path on the instance to the application .zip file.
       * The name of the zip file must be the name of the module to be installed
       */
    readonly source: IStringVariable;
    /**
       * (Optional) The SHA256 hash of the .zip file
       */
    readonly sourceHash?: IStringVariable;
    /**
       * (Optional) The time in seconds for a command to be completed before it's considered to have failed.
       * When the timeout is reached, Systems Manager stops the command execution.
       */
    readonly timeoutSeconds?: number;
    /**
       * (Optional) The path to the working directory on your instance.
       */
    readonly workingDirectory?: IStringVariable;
}
/**
 * AutomationStep implemenation for aws:psmodule
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-plugins.html#aws-psModule
 */
export declare class PsModuleStep extends CommandStep {
    readonly runCommand?: IStringVariable[];
    readonly source: IStringVariable;
    readonly sourceHash?: IStringVariable;
    readonly timeoutSeconds?: number;
    readonly workingDirectory?: IStringVariable;
    readonly platforms: Platform[];
    readonly action = "aws:psModule";
    constructor(scope: Construct, id: string, props: PsModuleStepProps);
    /**
       * Inputs required for this command includes both the runCommand variables and workingDirectory if provided.
       */
    listInputs(): string[];
    toSsmEntry(): {
        [name: string]: any;
    };
}
