"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.ExecuteStateMachineSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const data_type_1 = require("../../domain/data-type");
const response_code_1 = require("../../domain/response-code");
const aws_api_step_1 = require("../../parent-steps/automation/aws-api-step");
const wait_for_and_assert_1 = require("../../parent-steps/automation/sub-steps/wait-for-and-assert");
const prune_and_transform_record_1 = require("../../utils/prune-and-transform-record");
const automation_step_simulation_1 = require("../automation-step-simulation");
const automation_simulation_base_1 = require("./automation-simulation-base");
const aws_service_1 = require("../../domain/aws-service");
var ExecuteStateMachineStatus;
(function (ExecuteStateMachineStatus) {
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["RUNNING"] = 0] = "RUNNING";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["SUCCEEDED"] = 1] = "SUCCEEDED";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["FAILED"] = 2] = "FAILED";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["TIMED_OUT"] = 3] = "TIMED_OUT";
    ExecuteStateMachineStatus[ExecuteStateMachineStatus["ABORTED"] = 4] = "ABORTED";
})(ExecuteStateMachineStatus || (ExecuteStateMachineStatus = {}));
/**
 * AutomationStep implementation of [aws:executeStateMachine](https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-executeStateMachine.html)
 */
class ExecuteStateMachineSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:executeStateMachine';
        this.executeStateMachineStep = step;
        this.props = props;
    }
    executeStep(inputs) {
        const stateMachineArn = this.executeStateMachineStep.stateMachineArn.resolveToString(inputs);
        console.log(`ExecuteStateMachine: Invoke start execution of ${stateMachineArn}`);
        const executionId = this.startExecution(inputs);
        console.log(`ExecuteStateMachine: Started execution ${executionId}`);
        this.waitForExecution(executionId);
        console.log(`ExecuteStateMachine: Execution ${executionId} is complete`);
        return {};
    }
    startExecution(inputs) {
        const apiParams = prune_and_transform_record_1.pruneAndTransformRecord({
            stateMachineArn: this.executeStateMachineStep.stateMachineArn,
            name: this.executeStateMachineStep.executionName,
            input: this.executeStateMachineStep.input,
        }, x => x.resolve(inputs));
        const result = new automation_step_simulation_1.AutomationStepSimulation(new aws_api_step_1.AwsApiStep(new aws_cdk_lib_1.Stack(), 'startExecution', {
            service: aws_service_1.AwsService.STEP_FUNCTIONS,
            pascalCaseApi: 'StartExecution',
            apiParams: apiParams,
            outputs: [{
                    outputType: data_type_1.DataTypeEnum.STRING,
                    selector: '$.executionArn',
                    name: 'ExecutionId',
                }],
        }), this.props).invoke({});
        if (result.responseCode !== response_code_1.ResponseCode.SUCCESS) {
            throw new Error(`Failed to start execution ${apiParams.stateMachineArn}: ${result.stackTrace}`);
        }
        return result.outputs?.['startExecution.ExecutionId'];
    }
    waitForExecution(executionId) {
        wait_for_and_assert_1.waitForAndAssertResource({
            service: aws_service_1.AwsService.STEP_FUNCTIONS,
            pascalCaseApi: 'DescribeExecution',
            apiParams: {
                executionArn: executionId,
            },
            selector: '$.status',
            waitForValues: [
                ExecuteStateMachineStatus.ABORTED,
                ExecuteStateMachineStatus.FAILED,
                ExecuteStateMachineStatus.TIMED_OUT,
                ExecuteStateMachineStatus.SUCCEEDED,
            ].map(x => ExecuteStateMachineStatus[x]),
            desiredValues: [ExecuteStateMachineStatus[ExecuteStateMachineStatus.SUCCEEDED]],
        }, this.props);
    }
}
exports.ExecuteStateMachineSimulation = ExecuteStateMachineSimulation;
_a = JSII_RTTI_SYMBOL_1;
ExecuteStateMachineSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.ExecuteStateMachineSimulation", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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