"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AutomationSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_step_simulation_1 = require("../automation-step-simulation");
class AutomationSimulation {
    constructor(automationDocument, props) {
        this.automationDocument = automationDocument;
        this.props = props;
    }
    /**
     * Starts the execution of the steps by invoking the first step.
     * The subsequent steps will be invoked by the steps themselves.
     * @param inputs all of the inputs necessary for the document to execute.
     * @returns the outputs specified by all the steps.
     */
    start(inputs) {
        const dateString = new Date().toISOString(); // Example 2021-10-08T08:44:02.106Z
        inputs['global:DATE'] = dateString.split('T')[0];
        inputs['global:DATE_TIME'] = dateString.split('.')[0]
            .replace('T', '_') // Example 2021-10-08_08:44:02
            .replace(/:/g, '.');
        const prefix = Math.floor(Math.random() * 999999).toString().padStart(6, '0');
        inputs['automation:EXECUTION_ID'] = prefix + '-1a2b3c-1a2b3c-1a2b3c1a2b3c1a2b3c';
        return new automation_step_simulation_1.AutomationStepSimulation(this.createChain(this.automationDocument.collectedSteps()), this.props).invoke(inputs);
    }
    /**
     * Chains the steps together in their default orientation (like a linked list).
     * The order of steps can change depending on the properties provided to the steps.
     * @returns the first step of the chain
     */
    createChain(steps) {
        const firstStep = steps[0];
        let previousStep = firstStep;
        steps.slice(1).forEach(s => {
            previousStep.nextStep = previousStep.explicitNextStep?.resolve(steps) ?? s;
            previousStep.allStepsInExecution = steps;
            previousStep = s;
        });
        return firstStep;
    }
}
exports.AutomationSimulation = AutomationSimulation;
_a = JSII_RTTI_SYMBOL_1;
AutomationSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.AutomationSimulation", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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