"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.DataType = exports.DataTypeEnum = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const boolean_variable_1 = require("../interface/variables/boolean-variable");
const map_list_variable_1 = require("../interface/variables/map-list-variable");
const number_variable_1 = require("../interface/variables/number-variable");
const string_list_variable_1 = require("../interface/variables/string-list-variable");
const string_map_variable_1 = require("../interface/variables/string-map-variable");
const string_variable_1 = require("../interface/variables/string-variable");
/**
 * DataTypes as supported by SSM Documents.
 */
var DataTypeEnum;
(function (DataTypeEnum) {
    DataTypeEnum[DataTypeEnum["STRING"] = 0] = "STRING";
    DataTypeEnum[DataTypeEnum["INTEGER"] = 1] = "INTEGER";
    DataTypeEnum[DataTypeEnum["BOOLEAN"] = 2] = "BOOLEAN";
    DataTypeEnum[DataTypeEnum["STRING_LIST"] = 3] = "STRING_LIST";
    DataTypeEnum[DataTypeEnum["STRING_MAP"] = 4] = "STRING_MAP";
    DataTypeEnum[DataTypeEnum["MAP_LIST"] = 5] = "MAP_LIST";
})(DataTypeEnum = exports.DataTypeEnum || (exports.DataTypeEnum = {}));
/**
 * JSII does not allow functions or constants declared in an enum class directly.
 * Therefore, interaction with DataTypeEnum happens through this class.
 */
class DataType {
    constructor(dataTypeEnum) {
        this.dataTypeEnum = dataTypeEnum;
    }
    static fromDataType(ssmDataType) {
        const dataType = DataType.STRING_TO_DATA_TYPE[ssmDataType];
        if (dataType != undefined) {
            return new DataType(dataType);
        }
        else {
            throw new Error(`Runtime ${ssmDataType} not supported.`);
        }
    }
    /**
       * @returns the SSM string representation of this DataType
       */
    toSsmString() {
        const dataTypeEntry = Object.entries(DataType.STRING_TO_DATA_TYPE)
            .filter(entry => entry[1] == this.dataTypeEnum)[0];
        if (dataTypeEntry) {
            return dataTypeEntry[0];
        }
        else {
            throw new Error(`DataType ${this.dataTypeEnum} not supported.`);
        }
    }
    /**
       * @returns true if the input variable matches the associated dataTypeEnum
       */
    validateType(val) {
        if (val === null) {
            return true;
        }
        switch (this.dataTypeEnum) {
            case DataTypeEnum.STRING:
                return string_variable_1.isString(val);
            case DataTypeEnum.INTEGER:
                return number_variable_1.isNumber(val);
            case DataTypeEnum.BOOLEAN:
                return boolean_variable_1.isBoolean(val);
            case DataTypeEnum.STRING_LIST:
                return string_list_variable_1.isStringList(val);
            case DataTypeEnum.MAP_LIST:
                return map_list_variable_1.isMapList(val);
            case DataTypeEnum.STRING_MAP:
                return string_map_variable_1.isStringMap(val);
            default:
                throw new Error('DataTypeEnum not supported: ' + this.dataTypeEnum);
        }
    }
}
exports.DataType = DataType;
_a = JSII_RTTI_SYMBOL_1;
DataType[_a] = { fqn: "@cdklabs/cdk-ssm-documents.DataType", version: "0.0.34" };
DataType.STRING_TO_DATA_TYPE = {
    String: DataTypeEnum.STRING,
    Integer: DataTypeEnum.INTEGER,
    Boolean: DataTypeEnum.BOOLEAN,
    StringList: DataTypeEnum.STRING_LIST,
    StringMap: DataTypeEnum.STRING_MAP,
    MapList: DataTypeEnum.MAP_LIST,
};
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGF0YS10eXBlLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vc3JjL2RvbWFpbi9kYXRhLXR5cGUudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7QUFBQSw4RUFBb0U7QUFDcEUsZ0ZBQXFFO0FBQ3JFLDRFQUFrRTtBQUNsRSxzRkFBMkU7QUFDM0Usb0ZBQXlFO0FBQ3pFLDRFQUFrRTtBQUVsRTs7R0FFRztBQUNILElBQVksWUFPWDtBQVBELFdBQVksWUFBWTtJQUN0QixtREFBTSxDQUFBO0lBQ04scURBQU8sQ0FBQTtJQUNQLHFEQUFPLENBQUE7SUFDUCw2REFBVyxDQUFBO0lBQ1gsMkRBQVUsQ0FBQTtJQUNWLHVEQUFRLENBQUE7QUFDVixDQUFDLEVBUFcsWUFBWSxHQUFaLG9CQUFZLEtBQVosb0JBQVksUUFPdkI7QUFFRDs7O0dBR0c7QUFDSCxNQUFhLFFBQVE7SUFzQm5CLFlBQVksWUFBMEI7UUFDcEMsSUFBSSxDQUFDLFlBQVksR0FBRyxZQUFZLENBQUM7SUFDbkMsQ0FBQztJQXRCTSxNQUFNLENBQUMsWUFBWSxDQUFDLFdBQW1CO1FBQzVDLE1BQU0sUUFBUSxHQUFHLFFBQVEsQ0FBQyxtQkFBbUIsQ0FBQyxXQUFXLENBQUMsQ0FBQztRQUMzRCxJQUFJLFFBQVEsSUFBSSxTQUFTLEVBQUU7WUFDekIsT0FBTyxJQUFJLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztTQUMvQjthQUFNO1lBQ0wsTUFBTSxJQUFJLEtBQUssQ0FBQyxXQUFXLFdBQVcsaUJBQWlCLENBQUMsQ0FBQztTQUMxRDtJQUNILENBQUM7SUFpQkQ7O1NBRUs7SUFDRSxXQUFXO1FBQ2hCLE1BQU0sYUFBYSxHQUFHLE1BQU0sQ0FBQyxPQUFPLENBQUMsUUFBUSxDQUFDLG1CQUFtQixDQUFDO2FBQy9ELE1BQU0sQ0FBQyxLQUFLLENBQUMsRUFBRSxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDckQsSUFBSSxhQUFhLEVBQUU7WUFDakIsT0FBTyxhQUFhLENBQUMsQ0FBQyxDQUFDLENBQUM7U0FDekI7YUFBTTtZQUNMLE1BQU0sSUFBSSxLQUFLLENBQUMsWUFBWSxJQUFJLENBQUMsWUFBWSxpQkFBaUIsQ0FBQyxDQUFDO1NBQ2pFO0lBQ0gsQ0FBQztJQUVEOztTQUVLO0lBQ0UsWUFBWSxDQUFDLEdBQVE7UUFDMUIsSUFBSSxHQUFHLEtBQUssSUFBSSxFQUFFO1lBQUUsT0FBTyxJQUFJLENBQUM7U0FBRTtRQUNsQyxRQUFRLElBQUksQ0FBQyxZQUFZLEVBQUU7WUFDekIsS0FBSyxZQUFZLENBQUMsTUFBTTtnQkFDdEIsT0FBTywwQkFBUSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQ3ZCLEtBQUssWUFBWSxDQUFDLE9BQU87Z0JBQ3ZCLE9BQU8sMEJBQVEsQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUN2QixLQUFLLFlBQVksQ0FBQyxPQUFPO2dCQUN2QixPQUFPLDRCQUFTLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDeEIsS0FBSyxZQUFZLENBQUMsV0FBVztnQkFDM0IsT0FBTyxtQ0FBWSxDQUFDLEdBQUcsQ0FBQyxDQUFDO1lBQzNCLEtBQUssWUFBWSxDQUFDLFFBQVE7Z0JBQ3hCLE9BQU8sNkJBQVMsQ0FBQyxHQUFHLENBQUMsQ0FBQztZQUN4QixLQUFLLFlBQVksQ0FBQyxVQUFVO2dCQUMxQixPQUFPLGlDQUFXLENBQUMsR0FBRyxDQUFDLENBQUM7WUFDMUI7Z0JBQ0UsTUFBTSxJQUFJLEtBQUssQ0FBQyw4QkFBOEIsR0FBRyxJQUFJLENBQUMsWUFBWSxDQUFDLENBQUM7U0FDdkU7SUFDSCxDQUFDOztBQTVESCw0QkE4REM7OztBQW5EeUIsNEJBQW1CLEdBQXFDO0lBQzlFLE1BQU0sRUFBRSxZQUFZLENBQUMsTUFBTTtJQUMzQixPQUFPLEVBQUUsWUFBWSxDQUFDLE9BQU87SUFDN0IsT0FBTyxFQUFFLFlBQVksQ0FBQyxPQUFPO0lBQzdCLFVBQVUsRUFBRSxZQUFZLENBQUMsV0FBVztJQUNwQyxTQUFTLEVBQUUsWUFBWSxDQUFDLFVBQVU7SUFDbEMsT0FBTyxFQUFFLFlBQVksQ0FBQyxRQUFRO0NBQy9CLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBpc0Jvb2xlYW4gfSBmcm9tICcuLi9pbnRlcmZhY2UvdmFyaWFibGVzL2Jvb2xlYW4tdmFyaWFibGUnO1xuaW1wb3J0IHsgaXNNYXBMaXN0IH0gZnJvbSAnLi4vaW50ZXJmYWNlL3ZhcmlhYmxlcy9tYXAtbGlzdC12YXJpYWJsZSc7XG5pbXBvcnQgeyBpc051bWJlciB9IGZyb20gJy4uL2ludGVyZmFjZS92YXJpYWJsZXMvbnVtYmVyLXZhcmlhYmxlJztcbmltcG9ydCB7IGlzU3RyaW5nTGlzdCB9IGZyb20gJy4uL2ludGVyZmFjZS92YXJpYWJsZXMvc3RyaW5nLWxpc3QtdmFyaWFibGUnO1xuaW1wb3J0IHsgaXNTdHJpbmdNYXAgfSBmcm9tICcuLi9pbnRlcmZhY2UvdmFyaWFibGVzL3N0cmluZy1tYXAtdmFyaWFibGUnO1xuaW1wb3J0IHsgaXNTdHJpbmcgfSBmcm9tICcuLi9pbnRlcmZhY2UvdmFyaWFibGVzL3N0cmluZy12YXJpYWJsZSc7XG5cbi8qKlxuICogRGF0YVR5cGVzIGFzIHN1cHBvcnRlZCBieSBTU00gRG9jdW1lbnRzLlxuICovXG5leHBvcnQgZW51bSBEYXRhVHlwZUVudW0ge1xuICBTVFJJTkcsXG4gIElOVEVHRVIsXG4gIEJPT0xFQU4sXG4gIFNUUklOR19MSVNULFxuICBTVFJJTkdfTUFQLFxuICBNQVBfTElTVCxcbn1cblxuLyoqXG4gKiBKU0lJIGRvZXMgbm90IGFsbG93IGZ1bmN0aW9ucyBvciBjb25zdGFudHMgZGVjbGFyZWQgaW4gYW4gZW51bSBjbGFzcyBkaXJlY3RseS5cbiAqIFRoZXJlZm9yZSwgaW50ZXJhY3Rpb24gd2l0aCBEYXRhVHlwZUVudW0gaGFwcGVucyB0aHJvdWdoIHRoaXMgY2xhc3MuXG4gKi9cbmV4cG9ydCBjbGFzcyBEYXRhVHlwZSB7XG5cbiAgcHVibGljIHN0YXRpYyBmcm9tRGF0YVR5cGUoc3NtRGF0YVR5cGU6IHN0cmluZykge1xuICAgIGNvbnN0IGRhdGFUeXBlID0gRGF0YVR5cGUuU1RSSU5HX1RPX0RBVEFfVFlQRVtzc21EYXRhVHlwZV07XG4gICAgaWYgKGRhdGFUeXBlICE9IHVuZGVmaW5lZCkge1xuICAgICAgcmV0dXJuIG5ldyBEYXRhVHlwZShkYXRhVHlwZSk7XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgUnVudGltZSAke3NzbURhdGFUeXBlfSBub3Qgc3VwcG9ydGVkLmApO1xuICAgIH1cbiAgfVxuXG4gIHByaXZhdGUgc3RhdGljIHJlYWRvbmx5IFNUUklOR19UT19EQVRBX1RZUEU6IHsgW25hbWU6IHN0cmluZ106IERhdGFUeXBlRW51bSB9ID0ge1xuICAgIFN0cmluZzogRGF0YVR5cGVFbnVtLlNUUklORyxcbiAgICBJbnRlZ2VyOiBEYXRhVHlwZUVudW0uSU5URUdFUixcbiAgICBCb29sZWFuOiBEYXRhVHlwZUVudW0uQk9PTEVBTixcbiAgICBTdHJpbmdMaXN0OiBEYXRhVHlwZUVudW0uU1RSSU5HX0xJU1QsXG4gICAgU3RyaW5nTWFwOiBEYXRhVHlwZUVudW0uU1RSSU5HX01BUCxcbiAgICBNYXBMaXN0OiBEYXRhVHlwZUVudW0uTUFQX0xJU1QsXG4gIH07XG5cbiAgcmVhZG9ubHkgZGF0YVR5cGVFbnVtOiBEYXRhVHlwZUVudW07XG5cbiAgY29uc3RydWN0b3IoZGF0YVR5cGVFbnVtOiBEYXRhVHlwZUVudW0pIHtcbiAgICB0aGlzLmRhdGFUeXBlRW51bSA9IGRhdGFUeXBlRW51bTtcbiAgfVxuXG4gIC8qKlxuICAgICAqIEByZXR1cm5zIHRoZSBTU00gc3RyaW5nIHJlcHJlc2VudGF0aW9uIG9mIHRoaXMgRGF0YVR5cGVcbiAgICAgKi9cbiAgcHVibGljIHRvU3NtU3RyaW5nKCk6IHN0cmluZyB7XG4gICAgY29uc3QgZGF0YVR5cGVFbnRyeSA9IE9iamVjdC5lbnRyaWVzKERhdGFUeXBlLlNUUklOR19UT19EQVRBX1RZUEUpXG4gICAgICAuZmlsdGVyKGVudHJ5ID0+IGVudHJ5WzFdID09IHRoaXMuZGF0YVR5cGVFbnVtKVswXTtcbiAgICBpZiAoZGF0YVR5cGVFbnRyeSkge1xuICAgICAgcmV0dXJuIGRhdGFUeXBlRW50cnlbMF07XG4gICAgfSBlbHNlIHtcbiAgICAgIHRocm93IG5ldyBFcnJvcihgRGF0YVR5cGUgJHt0aGlzLmRhdGFUeXBlRW51bX0gbm90IHN1cHBvcnRlZC5gKTtcbiAgICB9XG4gIH1cblxuICAvKipcbiAgICAgKiBAcmV0dXJucyB0cnVlIGlmIHRoZSBpbnB1dCB2YXJpYWJsZSBtYXRjaGVzIHRoZSBhc3NvY2lhdGVkIGRhdGFUeXBlRW51bVxuICAgICAqL1xuICBwdWJsaWMgdmFsaWRhdGVUeXBlKHZhbDogYW55KTogYm9vbGVhbiB7XG4gICAgaWYgKHZhbCA9PT0gbnVsbCkgeyByZXR1cm4gdHJ1ZTsgfVxuICAgIHN3aXRjaCAodGhpcy5kYXRhVHlwZUVudW0pIHtcbiAgICAgIGNhc2UgRGF0YVR5cGVFbnVtLlNUUklORzpcbiAgICAgICAgcmV0dXJuIGlzU3RyaW5nKHZhbCk7XG4gICAgICBjYXNlIERhdGFUeXBlRW51bS5JTlRFR0VSOlxuICAgICAgICByZXR1cm4gaXNOdW1iZXIodmFsKTtcbiAgICAgIGNhc2UgRGF0YVR5cGVFbnVtLkJPT0xFQU46XG4gICAgICAgIHJldHVybiBpc0Jvb2xlYW4odmFsKTtcbiAgICAgIGNhc2UgRGF0YVR5cGVFbnVtLlNUUklOR19MSVNUOlxuICAgICAgICByZXR1cm4gaXNTdHJpbmdMaXN0KHZhbCk7XG4gICAgICBjYXNlIERhdGFUeXBlRW51bS5NQVBfTElTVDpcbiAgICAgICAgcmV0dXJuIGlzTWFwTGlzdCh2YWwpO1xuICAgICAgY2FzZSBEYXRhVHlwZUVudW0uU1RSSU5HX01BUDpcbiAgICAgICAgcmV0dXJuIGlzU3RyaW5nTWFwKHZhbCk7XG4gICAgICBkZWZhdWx0OlxuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ0RhdGFUeXBlRW51bSBub3Qgc3VwcG9ydGVkOiAnICsgdGhpcy5kYXRhVHlwZUVudW0pO1xuICAgIH1cbiAgfVxuXG59XG4iXX0=