"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.StepRef = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
/**
 * Class to reference AutomationSteps.
 * The class allows steps to be referenced by the Step object or by the step name.
 */
class StepRef {
    constructor(stepName) {
        this.stepName = stepName;
    }
    /**
     * Static constructor for creating a reference to a step from an AutomationStep object.
     */
    static fromObject(step) {
        return new StepRef(step.name);
    }
    /**
     * Static constructor for creating a reference to a step from a step name.
     */
    static fromName(stepName) {
        return new StepRef(stepName);
    }
    /**
     * Resolve to an AutomationStep object. Provide all the steps in the execution to find the associated step.
     */
    resolve(allStepsInExecution) {
        const stepObj = allStepsInExecution.filter(s => s.name == this.stepName);
        if (stepObj == undefined || stepObj.length != 1) {
            throw new Error('Cannot find step from reference: ' + this.stepName);
        }
        return stepObj[0];
    }
}
exports.StepRef = StepRef;
_a = JSII_RTTI_SYMBOL_1;
StepRef[_a] = { fqn: "@cdklabs/cdk-ssm-documents.StepRef", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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