import { IGenericVariable, GenericVariable, HardCodedValueBase } from './variable';
/**
 * StringMap type that can be null
 */
export declare type NullableStringMap = Record<string, any>;
/**
 * A string map variable
 */
export interface IStringMapVariable extends IGenericVariable {
    /**
       * Given the execution inputs, return the resolved value of this variable.
       * @param inputs are the execution inputs.
       */
    resolveToStringMap(inputs: Record<string, any>): NullableStringMap;
}
/**
 * A hard-coded string map variable.
 * Used when not dependent on step inputs.
 */
export declare class HardCodedStringMap extends HardCodedValueBase<Record<string, any>> implements IStringMapVariable {
    static of(val: Record<string, any>): HardCodedStringMap;
    resolveToStringMap(inputs: Record<string, any>): NullableStringMap;
    protected assertType(value: any): void;
}
/**
 * A string map variable reference.
 * Used to resolve the value from step inputs.
 */
export declare class StringMapVariable extends GenericVariable implements IStringMapVariable {
    static of(reference: string): StringMapVariable;
    resolveToStringMap(inputs: Record<string, any>): NullableStringMap;
    protected assertType(value: any): void;
}
/**
 * Assert that the given value is a NullableStringMap.
 * @param value value to assert
 */
export declare function assertStringMap(value: any): asserts value is NullableStringMap;
/**
 * Whether the given value is a NullableStringMap.
 * @param value value to check
 * @returns true if the value is a NullableStringMap, otherwise false
 */
export declare function isStringMap(value: any): value is NullableStringMap;
