import { Construct } from 'constructs';
import { Output } from '../../domain/output';
import { IAwsInvoker } from '../../interface/aws-invoker';
import { IStringMapVariable } from '../../interface/variables/string-map-variable';
import { IStringVariable } from '../../interface/variables/string-variable';
import { AutomationStep, AutomationStepProps } from '../automation-step';
/**
 * Properties for InvokeLambdaFunctionStep
 */
export interface InvokeLambdaFunctionStepProps extends AutomationStepProps {
    /**
       * The name of the Lambda function. This function must exist.
       */
    readonly functionName: IStringVariable;
    /**
       * (Optional) The function version or alias name.
       */
    readonly qualifier?: IStringVariable;
    /**
       * (Optional) The invocation type. The default value is RequestResponse.
       */
    readonly invocationType?: IStringVariable;
    /**
       * (Optional) If the default value is Tail, the invocation type must be RequestResponse. Lambda returns the last 4 KB of log data produced by your Lambda function, base64-encoded.
       */
    readonly logType?: IStringVariable;
    /**
       * (Optional) The client-specific information.
       */
    readonly clientContext?: IStringVariable;
    /**
       * (Optional) The JSON input for your Lambda function.
       */
    readonly payload?: IStringMapVariable;
}
/**
 * AutomationStep implemenation for aws:invokeLambdaFunction
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-lamb.html
 */
export declare class InvokeLambdaFunctionStep extends AutomationStep {
    readonly action: string;
    readonly awsInvoker?: IAwsInvoker;
    readonly functionName: IStringVariable;
    readonly qualifier?: IStringVariable;
    readonly invocationType?: IStringVariable;
    readonly logType?: IStringVariable;
    readonly clientContext?: IStringVariable;
    readonly payload?: IStringMapVariable;
    constructor(scope: Construct, id: string, props: InvokeLambdaFunctionStepProps);
    listOutputs(): Output[];
    listInputs(): string[];
    toSsmEntry(): Record<string, any>;
    private formatInputMap;
}
