import { StackStatus } from '../../../domain/stack-status';
import { WaitForAndAssertResourceProps } from '../../../patterns/automation/wait-for-and-assert-resource';
import { SimulationProps } from '../../../simulation/simulation';
/**
 * Wait for and assert on an EC2 resource value
 */
export declare function waitForAndAssertResource(props: WaitForAndAssertResourceProps, simulationProps: SimulationProps): void;
/**
 * Props for waitForAndAssertInstanceState
 */
interface WaitForAndAssertInstanceStateProps {
    /**
       * States to wait for
       */
    waitForState: string[];
    /**
       * State to assert
       */
    assertState: string;
    /**
       * Instance IDs to wait for and assert on
       */
    instanceIds: string[];
}
/**
 * Wait for and assert on an EC2 instance state
 */
export declare function waitForAndAssertInstanceState(props: WaitForAndAssertInstanceStateProps, simulationProps: SimulationProps): void;
/**
 * Props for waitForAndAssertInstanceStatus
 */
interface WaitForAndAssertInstanceStatusProps {
    /**
       * Statuses to wait for
       */
    waitForStatus: string[];
    /**
       * Status to assert
       */
    assertStatus: string;
    /**
       * Instance IDs to wait for and assert on
       */
    instanceIds: string[];
}
/**
 * Wait for and assert on an EC2 instance status
 */
export declare function waitForAndAssertInstanceStatus(props: WaitForAndAssertInstanceStatusProps, simulationProps: SimulationProps): void;
/**
 * Props for waitForAndAssertImageAvailable
 */
interface WaitForAndAssertImageStateProps {
    /**
       * Image ID to wait for and assert on
       */
    imageId: string;
}
/**
 * Wait for and assert on an EC2 image for available state
 */
export declare function waitForAndAssertImageAvailable(props: WaitForAndAssertImageStateProps, simulationProps: SimulationProps): void;
/**
 * Props for waitForAndAssertStackStatus
 */
interface WaitForAndAssertStackStatusProps {
    /**
       * Statuses to wait for
       */
    waitForStatus: StackStatus[];
    /**
       * Status to assert
       */
    assertStatus: StackStatus;
    /**
       * Stack name to wait for and assert status of
       */
    stackName: string;
}
/**
 * Wait for and assert on a stack's status
 */
export declare function waitForAndAssertStackStatus(props: WaitForAndAssertStackStatusProps, simulationProps: SimulationProps): void;
export {};
