import { IAwsInvoker } from '../../interface/aws-invoker';
import { ISleepHook } from '../../interface/sleep-hook';
import { DeleteImageStep } from '../../parent-steps/automation/delete-image-step';
import { AutomationSimulationBase } from './automation-simulation-base';
/**
 * Properties for DeleteImageStep
 */
export interface DeleteImageSimulationProps {
    /**
       * (Optional) Use this as a hook to inject an alternate IAwsInvoker (for mocking the AWS API call).
       * @default - will perform a real invocation of the JavaScript AWS SDK using ReflectiveAwsInvoker class.
       */
    readonly awsInvoker?: IAwsInvoker;
    /**
       * (Optional) Whether to really perform a pause of the runtime.
       * To override sleep behavior, inject an ISleepHook impl or use the provided MockSleep class.
       * @default SleeperImpl
       */
    readonly sleepHook?: ISleepHook;
}
/**
 * AutomationStep implementation for aws:deleteImage
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-delete.html
 */
export declare class DeleteImageSimulation extends AutomationSimulationBase {
    readonly action: string;
    private deleteImageStep;
    private props;
    constructor(step: DeleteImageStep, props: DeleteImageSimulationProps);
    executeStep(inputs: Record<string, any>): Record<string, any>;
    private getSnapshots;
    private deregisterImage;
    private deleteSnapshotsOfImage;
    private deleteSnapshot;
}
