"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.PauseSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const automation_simulation_base_1 = require("./automation-simulation-base");
/**
 * AutomationStep implementation for aws:pause
 * https://docs.aws.amazon.com/systems-manager/latest/userguide/automation-action-pause.html
 */
class PauseSimulation extends automation_simulation_base_1.AutomationSimulationBase {
    constructor(step, props) {
        super(step);
        this.action = 'aws:pause';
        this.props = props;
    }
    /**
       * May perform a real pause based on the params used during instance creation.
       */
    executeStep(_inputs) {
        this.props.pauseHook.pause();
        return {};
    }
}
exports.PauseSimulation = PauseSimulation;
_a = JSII_RTTI_SYMBOL_1;
PauseSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.PauseSimulation", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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