"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.RunShellScriptSimulation = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const command_simulation_base_1 = require("./command-simulation-base");
class RunShellScriptSimulation extends command_simulation_base_1.CommandSimulationBase {
    constructor(step, props) {
        super();
        this.step = step;
        this.props = props;
    }
    /**
     * Executes the runCommands against the environment provided in the constructor.
     */
    executeStep(inputs) {
        this.step.runCommand.forEach(cmd => {
            const command = cmd.resolve(inputs);
            // TODO what should we enclose the string with if it contains both ' and "
            const quote = command.includes("\'") ? '\"' : '\'';
            this.props.environment.run(`bash -c ${quote}${command}${quote}`);
        });
    }
}
exports.RunShellScriptSimulation = RunShellScriptSimulation;
_a = JSII_RTTI_SYMBOL_1;
RunShellScriptSimulation[_a] = { fqn: "@cdklabs/cdk-ssm-documents.RunShellScriptSimulation", version: "0.0.34" };
//# sourceMappingURL=data:application/json;base64,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