static const char script_hebios[] =
"#\n"
"# Script for creating hebios-50na.bin\n"
"#\n"
"\n"
"load image/ps2-50na.bin\n"
"\n"
"# Necessary to maintain block before ROMDIR\n"
"pin reset\n"
"\n"
"# Necessary fixed modules for PS1\n"
"pin tbin\n"
"pin sbin\n"
"# Necessary fixed modules for PS2\n"
"pin iopboot\n"
"# IOPBTCONF\n"
"iopbtconf he-iopbtconf.txt\n"
"# Rebuild the ROM image.\n"
"rebuild\n"
"# PS1 preboot patch\n"
"#patch 52360: DC 34 F1 0F 07 00 04 24: FF FF 00 10 00 00 00 00\n"
"# PS2 preboot patch\n"
"#patch 4A448: 00 00 00 00 09 F8 40 00 21 20 60 02: 21 20 60 02 FF FF 00 10 00 00 00 00\n"
"# BIOS environment\n"
"#asc 80: \"Highly Experimental ps1preboot=52360 ps2preboot=4A44C\"\n"
"\n"
"save hebios-50na.bin\n";

static const char script_iopbtconf[] =
"#\n"
"# IOPBTCONF for Highly Experimental\n"
"#\n"
"# Note that mkhebios will strip blank lines or\n"
"# lines starting with '#' because the real BIOS\n"
"# doesn't.\n"
"#\n"
"# start at 0x800 in memory\n"
"@800\n"
"# these first two are loaded by the bios (preboot)\n"
"SYSMEM\n"
"LOADCORE\n"
"\n"
"EXCEPMAN\n"
"# seems unnecessary. does nothing if in native IOP mode\n"
"# INTRMANP\n"
"# this is probably the native IOP version\n"
"INTRMANI\n"
"\n"
"SSBUSC\n"
"DMACMAN\n"
"\n"
"# seems unnecessary. does nothing if in native IOP mode\n"
"# TIMEMANP\n"
"# this is probably the native IOP version\n"
"TIMEMANI\n"
"\n"
"SYSCLIB\n"
"HEAPLIB\n"
"\n"
"# disabled - hang\n"
"# EECONF\n"
"\n"
"THREADMAN\n"
"VBLANK\n"
"\n"
"IOMAN\n"
"# ttyhack overwrites the tty function pointer for H.E. (obsolete)\n"
"# TTYHACK,C\n"
"# modload does LoadStartModule and all that stuff\n"
"# it needs to be loaded after ioman because it uses I/O\n"
"MODLOAD\n"
"\n"
"# doesn't seem necessary.\n"
"# this does what it says - registers a \"rom:\" device in ioman\n"
"# which can read files from the BFC00000-BFFFFFFF area\n"
"# ROMDRV\n"
"\n"
"# stdio does printf, mainly. it's just a ioman write() wrapper.\n"
"STDIO\n"
"SIFMAN\n"
"IGREETING\n"
"SIFCMD\n"
"# the RebootByEE module isn't of much use without a EE\n"
"# REBOOT\n"
"LOADFILE\n"
"\n"
"# not much point to these since there is no CD/DVD emulation yet\n"
"# CDVDMAN\n"
"# CDVDFSV\n"
"\n"
"SIFINIT\n"
"FILEIO\n"
"\n"
"# this won't link because it needs cdvdman.\n"
"# probably copy protection related.\n"
"# SECRMAN\n"
"\n"
"# disabled - hang\n"
"# EESYNC\n"
"\n"
"# hefile sets up the hefile: device and runs hefile:/psf2.irx (obsolete)\n"
"# HEFILE,C\n"
"\n"
"# unified HE environment\n"
"HE,C\n"
"\n"
"# done\n";
