#!/usr/bin/python3
"""
    GeckoConfigStruct - A class to manage the ConfigStruct for 'InYT v56'
"""

from . import (
    GeckoByteStructAccessor,
    GeckoWordStructAccessor,
    GeckoTimeStructAccessor,
    GeckoBoolStructAccessor,
    GeckoEnumStructAccessor,
    GeckoTempStructAccessor,
)


class GeckoConfigStruct:
    def __init__(self, struct_):
        self.struct = struct_

    @property
    def version(self):
        return 56

    @property
    def output_keys(self):
        return [
            "Out1",
            "Out2",
            "Out3",
            "Out4",
            "Out5",
            "OutHtr",
            "Out6",
            "Out7",
            "Out8",
            "Out9",
            "Out10",
            "Out11",
            "Out12",
            "Direct",
            "Direct2",
            "OutLi",
        ]

    @property
    def accessors(self):
        return {
            "ConfigNumber": GeckoByteStructAccessor(
                self.struct, "ConfigNumber", 0, "ALL"
            ),
            "Out1": GeckoEnumStructAccessor(
                self.struct,
                "Out1",
                12,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out2": GeckoEnumStructAccessor(
                self.struct,
                "Out2",
                13,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out3": GeckoEnumStructAccessor(
                self.struct,
                "Out3",
                14,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out4": GeckoEnumStructAccessor(
                self.struct,
                "Out4",
                15,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out5": GeckoEnumStructAccessor(
                self.struct,
                "Out5",
                16,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "OutHtr": GeckoEnumStructAccessor(
                self.struct,
                "OutHtr",
                26,
                None,
                [
                    "NA",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                ],
                None,
                None,
                "ALL",
            ),
            "Out1Cur": GeckoByteStructAccessor(self.struct, "Out1Cur", 36, "ALL"),
            "Out2Cur": GeckoByteStructAccessor(self.struct, "Out2Cur", 37, "ALL"),
            "Out3Cur": GeckoByteStructAccessor(self.struct, "Out3Cur", 38, "ALL"),
            "Out4Cur": GeckoByteStructAccessor(self.struct, "Out4Cur", 39, "ALL"),
            "Out5Cur": GeckoByteStructAccessor(self.struct, "Out5Cur", 40, "ALL"),
            "OutHtRCur": GeckoByteStructAccessor(self.struct, "OutHtRCur", 50, "ALL"),
            "Out6": GeckoEnumStructAccessor(
                self.struct,
                "Out6",
                17,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out7": GeckoEnumStructAccessor(
                self.struct,
                "Out7",
                18,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out8": GeckoEnumStructAccessor(
                self.struct,
                "Out8",
                19,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out9": GeckoEnumStructAccessor(
                self.struct,
                "Out9",
                20,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out10": GeckoEnumStructAccessor(
                self.struct,
                "Out10",
                21,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out11": GeckoEnumStructAccessor(
                self.struct,
                "Out11",
                22,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Out12": GeckoEnumStructAccessor(
                self.struct,
                "Out12",
                23,
                None,
                [
                    "NA",
                    "P1H",
                    "P1L",
                    "P2H",
                    "P2L",
                    "P3H",
                    "P3L",
                    "P4H",
                    "P4L",
                    "P5",
                    "BLO",
                    "CP",
                    "O3",
                    "L120",
                    "HTR",
                    "",
                    "Fan",
                    "",
                    "",
                    "FullOn",
                    "",
                    "",
                    "",
                    "",
                    "",
                    "HTR2",
                    "Waterfall",
                ],
                None,
                None,
                "ALL",
            ),
            "Direct": GeckoEnumStructAccessor(
                self.struct,
                "Direct",
                24,
                None,
                ["NA", "", "", "", "", "", "", "", "", "", "", "CP"],
                None,
                None,
                "ALL",
            ),
            "Direct2": GeckoEnumStructAccessor(
                self.struct,
                "Direct2",
                25,
                None,
                ["NA", "", "", "", "", "", "", "", "", "", "", "CP"],
                None,
                None,
                "ALL",
            ),
            "Out6Cur": GeckoByteStructAccessor(self.struct, "Out6Cur", 41, "ALL"),
            "Out7Cur": GeckoByteStructAccessor(self.struct, "Out7Cur", 42, "ALL"),
            "Out8Cur": GeckoByteStructAccessor(self.struct, "Out8Cur", 43, "ALL"),
            "Out9Cur": GeckoByteStructAccessor(self.struct, "Out9Cur", 44, "ALL"),
            "Out10Cur": GeckoByteStructAccessor(self.struct, "Out10Cur", 45, "ALL"),
            "Out11Cur": GeckoByteStructAccessor(self.struct, "Out11Cur", 46, "ALL"),
            "Out12Cur": GeckoByteStructAccessor(self.struct, "Out12Cur", 47, "ALL"),
            "DirectCur": GeckoByteStructAccessor(self.struct, "DirectCur", 48, "ALL"),
            "Direct2Cur": GeckoByteStructAccessor(self.struct, "Direct2Cur", 49, "ALL"),
            "OutLi": GeckoEnumStructAccessor(
                self.struct,
                "OutLi",
                79,
                None,
                ["", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "LI"],
                None,
                None,
                None,
            ),
            "LightInts": GeckoByteStructAccessor(self.struct, "LightInts", 80, None),
            "PumpTimeOut": GeckoByteStructAccessor(
                self.struct, "PumpTimeOut", 54, "ALL"
            ),
            "LightTimeOut": GeckoByteStructAccessor(
                self.struct, "LightTimeOut", 55, "ALL"
            ),
            "L120TimeOut": GeckoByteStructAccessor(
                self.struct, "L120TimeOut", 56, "ALL"
            ),
            "L120Timer": GeckoEnumStructAccessor(
                self.struct, "L120Timer", 81, 0, ["Shared", "Own"], None, 2, "ALL"
            ),
            "WaterfallTimeOut": GeckoByteStructAccessor(
                self.struct, "WaterfallTimeOut", 118, "ALL"
            ),
            "FiltInterface": GeckoEnumStructAccessor(
                self.struct,
                "FiltInterface",
                32,
                None,
                ["PurgeOnly", "FiltCP", "FiltP1", "FiltP1DurOnly"],
                None,
                None,
                "ALL",
            ),
            "CpUsage": GeckoEnumStructAccessor(
                self.struct,
                "CpUsage",
                27,
                None,
                ["STANDARD", "ALWAYS_ON"],
                None,
                None,
                "ALL",
            ),
            "OtOption": GeckoEnumStructAccessor(
                self.struct,
                "OtOption",
                57,
                None,
                ["Disabled", "AlwaysEnabled", "WithSPOver95F"],
                None,
                None,
                "ALL",
            ),
            "PurgeSpeed": GeckoEnumStructAccessor(
                self.struct, "PurgeSpeed", 81, 2, ["Lo", "Hi"], None, 2, "ALL"
            ),
            "OTTriggerG": GeckoByteStructAccessor(self.struct, "OTTriggerG", 58, "ALL"),
            "CpOnTimeDuringOT": GeckoByteStructAccessor(
                self.struct, "CpOnTimeDuringOT", 59, "ALL"
            ),
            "CpOffTimeDuringOT": GeckoByteStructAccessor(
                self.struct, "CpOffTimeDuringOT", 60, "ALL"
            ),
            "FiltOnTimeDuringOT": GeckoByteStructAccessor(
                self.struct, "FiltOnTimeDuringOT", 61, "ALL"
            ),
            "FiltSuspendTime": GeckoByteStructAccessor(
                self.struct, "FiltSuspendTime", 62, "ALL"
            ),
            "DrainMode": GeckoEnumStructAccessor(
                self.struct,
                "DrainMode",
                78,
                None,
                ["NA", "P1", "CP"],
                None,
                None,
                "ALL",
            ),
            "O3Usage": GeckoEnumStructAccessor(
                self.struct,
                "O3Usage",
                28,
                None,
                ["Filter", "Always"],
                None,
                None,
                "ALL",
            ),
            "O3Pump": GeckoEnumStructAccessor(
                self.struct, "O3Pump", 29, None, ["CP", "P1"], None, None, "ALL"
            ),
            "O3Type": GeckoEnumStructAccessor(
                self.struct,
                "O3Type",
                30,
                None,
                ["Standard", "Toggle"],
                None,
                None,
                "ALL",
            ),
            "O3SuspendTime": GeckoByteStructAccessor(
                self.struct, "O3SuspendTime", 63, "ALL"
            ),
            "SetpointG": GeckoTempStructAccessor(self.struct, "SetpointG", 1, "ALL"),
            "TempUnits": GeckoEnumStructAccessor(
                self.struct, "TempUnits", 33, None, ["F", "C"], None, None, "ALL"
            ),
            "HeaterPump": GeckoEnumStructAccessor(
                self.struct, "HeaterPump", 31, None, ["CP", "P1"], None, None, "ALL"
            ),
            "FlowDetector": GeckoEnumStructAccessor(
                self.struct,
                "FlowDetector",
                115,
                None,
                ["inFlo", "NotInstalled", "PressureSwitch"],
                None,
                None,
                "ALL",
            ),
            "ProbeLocation": GeckoEnumStructAccessor(
                self.struct,
                "ProbeLocation",
                81,
                3,
                ["IntoPiping", "IntoTub"],
                None,
                2,
                "ALL",
            ),
            "CooldownTime": GeckoByteStructAccessor(
                self.struct, "CooldownTime", 35, "ALL"
            ),
            "MinSetpointG": GeckoTempStructAccessor(
                self.struct, "MinSetpointG", 66, "ALL"
            ),
            "MaxSetpointG": GeckoTempStructAccessor(
                self.struct, "MaxSetpointG", 68, "ALL"
            ),
            "EconType": GeckoEnumStructAccessor(
                self.struct,
                "EconType",
                70,
                None,
                ["Standard", "Night"],
                None,
                None,
                "ALL",
            ),
            "NoHeatPeriod": GeckoByteStructAccessor(
                self.struct, "NoHeatPeriod", 77, "ALL"
            ),
            "MaxNumberOfPhases": GeckoByteStructAccessor(
                self.struct, "MaxNumberOfPhases", 114, "ALL"
            ),
            "UL_CE": GeckoEnumStructAccessor(
                self.struct, "UL_CE", 51, None, ["UL", "CE"], None, None, "ALL"
            ),
            "NbPhases": GeckoByteStructAccessor(self.struct, "NbPhases", 52, "ALL"),
            "InputCurrent": GeckoByteStructAccessor(
                self.struct, "InputCurrent", 53, "ALL"
            ),
            "InputMenu": GeckoEnumStructAccessor(
                self.struct,
                "InputMenu",
                74,
                None,
                ["Standard", "DualPack"],
                None,
                None,
                "ALL",
            ),
            "Out1Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out1Fuse",
                83,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out2Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out2Fuse",
                84,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out3Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out3Fuse",
                85,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out4Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out4Fuse",
                86,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out5Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out5Fuse",
                87,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out6Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out6Fuse",
                88,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out7Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out7Fuse",
                89,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out8Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out8Fuse",
                90,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out9Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out9Fuse",
                91,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out10Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out10Fuse",
                92,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out11Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out11Fuse",
                93,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Out12Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Out12Fuse",
                94,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Direct1Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Direct1Fuse",
                95,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "Direct2Fuse": GeckoEnumStructAccessor(
                self.struct,
                "Direct2Fuse",
                96,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "OutHtrFuse": GeckoEnumStructAccessor(
                self.struct,
                "OutHtrFuse",
                97,
                None,
                ["F1", "F2", "F3", "F21", "F22", "F23", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "F1Current": GeckoByteStructAccessor(self.struct, "F1Current", 98, "ALL"),
            "F2Current": GeckoByteStructAccessor(self.struct, "F2Current", 99, "ALL"),
            "F3Current": GeckoByteStructAccessor(self.struct, "F3Current", 100, "ALL"),
            "F21Current": GeckoByteStructAccessor(
                self.struct, "F21Current", 101, "ALL"
            ),
            "F22Current": GeckoByteStructAccessor(
                self.struct, "F22Current", 102, "ALL"
            ),
            "F23Current": GeckoByteStructAccessor(
                self.struct, "F23Current", 103, "ALL"
            ),
            "F1Line": GeckoEnumStructAccessor(
                self.struct,
                "F1Line",
                104,
                None,
                ["", "", "", "", "", "", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "F2Line": GeckoEnumStructAccessor(
                self.struct,
                "F2Line",
                105,
                None,
                ["", "", "", "", "", "", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "F3Line": GeckoEnumStructAccessor(
                self.struct,
                "F3Line",
                106,
                None,
                ["", "", "", "", "", "", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "F21Line": GeckoEnumStructAccessor(
                self.struct,
                "F21Line",
                107,
                None,
                ["", "", "", "", "", "", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "F22Line": GeckoEnumStructAccessor(
                self.struct,
                "F22Line",
                108,
                None,
                ["", "", "", "", "", "", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "F23Line": GeckoEnumStructAccessor(
                self.struct,
                "F23Line",
                109,
                None,
                ["", "", "", "", "", "", "Line1", "Line2", "Line3"],
                None,
                None,
                "ALL",
            ),
            "FiltFreq": GeckoByteStructAccessor(self.struct, "FiltFreq", 3, "ALL"),
            "FiltStart": GeckoTimeStructAccessor(self.struct, "FiltStart", 4, "ALL"),
            "FiltDur": GeckoTimeStructAccessor(self.struct, "FiltDur", 6, "ALL"),
            "FiltDur2": GeckoTimeStructAccessor(self.struct, "FiltDur2", 116, "ALL"),
            "EconStart": GeckoTimeStructAccessor(self.struct, "EconStart", 8, "ALL"),
            "EconDur": GeckoTimeStructAccessor(self.struct, "EconDur", 10, "ALL"),
            "EconProgAvailable": GeckoEnumStructAccessor(
                self.struct,
                "EconProgAvailable",
                71,
                None,
                ["NA", "STANDARD", "OUTSIDE_FILTER"],
                None,
                None,
                "ALL",
            ),
            "UDProgEcon": GeckoBoolStructAccessor(
                self.struct, "UDProgEcon", 82, 0, "ALL"
            ),
            "EconControlableManually": GeckoBoolStructAccessor(
                self.struct, "EconControlableManually", 72, 2, "ALL"
            ),
            "SoakOnCustomKey": GeckoBoolStructAccessor(
                self.struct, "SoakOnCustomKey", 72, 0, "ALL"
            ),
            "OffOnCustomKey": GeckoBoolStructAccessor(
                self.struct, "OffOnCustomKey", 72, 1, "ALL"
            ),
            "CleanupOnCustomKey": GeckoBoolStructAccessor(
                self.struct, "CleanupOnCustomKey", 72, 3, "ALL"
            ),
            "MultiKeyOption": GeckoEnumStructAccessor(
                self.struct,
                "MultiKeyOption",
                76,
                None,
                ["NoBlowerOnI2C", "BlowerOnI2C"],
                None,
                None,
                "ALL",
            ),
            "MasterSlave": GeckoEnumStructAccessor(
                self.struct,
                "MasterSlave",
                73,
                None,
                ["", "Master", "Slave"],
                None,
                None,
                "ALL",
            ),
            "SlaveConfig": GeckoByteStructAccessor(
                self.struct, "SlaveConfig", 75, "ALL"
            ),
            "TimeFormat": GeckoEnumStructAccessor(
                self.struct,
                "TimeFormat",
                34,
                None,
                ["NA", "AmPm", "24h"],
                None,
                None,
                "ALL",
            ),
            "AmbiantOHTrigADC": GeckoWordStructAccessor(
                self.struct, "AmbiantOHTrigADC", 64, "ALL"
            ),
            "Pump1UserAccess": GeckoEnumStructAccessor(
                self.struct,
                "Pump1UserAccess",
                81,
                1,
                ["BothSpeeds", "HighSpeedOnly"],
                None,
                2,
                "ALL",
            ),
            "SelfCleanMsg": GeckoBoolStructAccessor(
                self.struct, "SelfCleanMsg", 81, 4, "ALL"
            ),
            "BlowerKeyOption": GeckoEnumStructAccessor(
                self.struct,
                "BlowerKeyOption",
                81,
                5,
                ["FreePumpKey", "LastPumpKey"],
                None,
                2,
                "ALL",
            ),
            "HeaterSoftStart": GeckoBoolStructAccessor(
                self.struct, "HeaterSoftStart", 81, 6, "ALL"
            ),
            "HeaterSoftStop": GeckoBoolStructAccessor(
                self.struct, "HeaterSoftStop", 81, 7, "ALL"
            ),
            "KeypadOptions1": GeckoByteStructAccessor(
                self.struct, "KeypadOptions1", 110, "ALL"
            ),
            "KeypadOptions2": GeckoByteStructAccessor(
                self.struct, "KeypadOptions2", 111, "ALL"
            ),
            "KeypadOptions3": GeckoByteStructAccessor(
                self.struct, "KeypadOptions3", 112, "ALL"
            ),
            "KeypadOptions4": GeckoByteStructAccessor(
                self.struct, "KeypadOptions4", 113, "ALL"
            ),
        }
