# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetDataKeysResult',
    'AwaitableGetDataKeysResult',
    'get_data_keys',
    'get_data_keys_output',
]

@pulumi.output_type
class GetDataKeysResult:
    """
    A collection of values returned by getDataKeys.
    """
    def __init__(__self__, apm_domain_id=None, data_key_type=None, data_keys=None, filters=None, id=None):
        if apm_domain_id and not isinstance(apm_domain_id, str):
            raise TypeError("Expected argument 'apm_domain_id' to be a str")
        pulumi.set(__self__, "apm_domain_id", apm_domain_id)
        if data_key_type and not isinstance(data_key_type, str):
            raise TypeError("Expected argument 'data_key_type' to be a str")
        pulumi.set(__self__, "data_key_type", data_key_type)
        if data_keys and not isinstance(data_keys, list):
            raise TypeError("Expected argument 'data_keys' to be a list")
        pulumi.set(__self__, "data_keys", data_keys)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter(name="apmDomainId")
    def apm_domain_id(self) -> str:
        return pulumi.get(self, "apm_domain_id")

    @property
    @pulumi.getter(name="dataKeyType")
    def data_key_type(self) -> Optional[str]:
        return pulumi.get(self, "data_key_type")

    @property
    @pulumi.getter(name="dataKeys")
    def data_keys(self) -> Sequence['outputs.GetDataKeysDataKeyResult']:
        """
        The list of data_keys.
        """
        return pulumi.get(self, "data_keys")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetDataKeysFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDataKeysResult(GetDataKeysResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDataKeysResult(
            apm_domain_id=self.apm_domain_id,
            data_key_type=self.data_key_type,
            data_keys=self.data_keys,
            filters=self.filters,
            id=self.id)


def get_data_keys(apm_domain_id: Optional[str] = None,
                  data_key_type: Optional[str] = None,
                  filters: Optional[Sequence[Union['GetDataKeysFilterArgs', 'GetDataKeysFilterArgsDict']]] = None,
                  opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDataKeysResult:
    """
    This data source provides the list of Data Keys in Oracle Cloud Infrastructure Apm service.

    Lists all Data Keys for the specified APM domain. The caller may filter the list by specifying the 'dataKeyType'
    query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_keys = oci.Apm.get_data_keys(apm_domain_id=test_apm_domain["id"],
        data_key_type=data_key_data_key_type)
    ```


    :param str apm_domain_id: The OCID of the APM domain
    :param str data_key_type: Data key type.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['dataKeyType'] = data_key_type
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Apm/getDataKeys:getDataKeys', __args__, opts=opts, typ=GetDataKeysResult).value

    return AwaitableGetDataKeysResult(
        apm_domain_id=pulumi.get(__ret__, 'apm_domain_id'),
        data_key_type=pulumi.get(__ret__, 'data_key_type'),
        data_keys=pulumi.get(__ret__, 'data_keys'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'))
def get_data_keys_output(apm_domain_id: Optional[pulumi.Input[str]] = None,
                         data_key_type: Optional[pulumi.Input[Optional[str]]] = None,
                         filters: Optional[pulumi.Input[Optional[Sequence[Union['GetDataKeysFilterArgs', 'GetDataKeysFilterArgsDict']]]]] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDataKeysResult]:
    """
    This data source provides the list of Data Keys in Oracle Cloud Infrastructure Apm service.

    Lists all Data Keys for the specified APM domain. The caller may filter the list by specifying the 'dataKeyType'
    query parameter.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_data_keys = oci.Apm.get_data_keys(apm_domain_id=test_apm_domain["id"],
        data_key_type=data_key_data_key_type)
    ```


    :param str apm_domain_id: The OCID of the APM domain
    :param str data_key_type: Data key type.
    """
    __args__ = dict()
    __args__['apmDomainId'] = apm_domain_id
    __args__['dataKeyType'] = data_key_type
    __args__['filters'] = filters
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Apm/getDataKeys:getDataKeys', __args__, opts=opts, typ=GetDataKeysResult)
    return __ret__.apply(lambda __response__: GetDataKeysResult(
        apm_domain_id=pulumi.get(__response__, 'apm_domain_id'),
        data_key_type=pulumi.get(__response__, 'data_key_type'),
        data_keys=pulumi.get(__response__, 'data_keys'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id')))
