# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = [
    'GetCatalogsResult',
    'AwaitableGetCatalogsResult',
    'get_catalogs',
    'get_catalogs_output',
]

@pulumi.output_type
class GetCatalogsResult:
    """
    A collection of values returned by getCatalogs.
    """
    def __init__(__self__, catalogs=None, compartment_id=None, display_name=None, filters=None, id=None, state=None):
        if catalogs and not isinstance(catalogs, list):
            raise TypeError("Expected argument 'catalogs' to be a list")
        pulumi.set(__self__, "catalogs", catalogs)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if filters and not isinstance(filters, list):
            raise TypeError("Expected argument 'filters' to be a list")
        pulumi.set(__self__, "filters", filters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter
    def catalogs(self) -> Sequence['outputs.GetCatalogsCatalogResult']:
        """
        The list of catalogs.
        """
        return pulumi.get(self, "catalogs")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Compartment identifier.
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> Optional[str]:
        """
        Data catalog identifier, which can be renamed.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def filters(self) -> Optional[Sequence['outputs.GetCatalogsFilterResult']]:
        return pulumi.get(self, "filters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def state(self) -> Optional[str]:
        """
        The current state of the data catalog resource.
        """
        return pulumi.get(self, "state")


class AwaitableGetCatalogsResult(GetCatalogsResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetCatalogsResult(
            catalogs=self.catalogs,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            filters=self.filters,
            id=self.id,
            state=self.state)


def get_catalogs(compartment_id: Optional[str] = None,
                 display_name: Optional[str] = None,
                 filters: Optional[Sequence[Union['GetCatalogsFilterArgs', 'GetCatalogsFilterArgsDict']]] = None,
                 state: Optional[str] = None,
                 opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetCatalogsResult:
    """
    This data source provides the list of Catalogs in Oracle Cloud Infrastructure Data Catalog service.

    Returns a list of all the data catalogs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalogs = oci.DataCatalog.get_catalogs(compartment_id=compartment_id,
        display_name=catalog_display_name,
        state=catalog_state)
    ```


    :param str compartment_id: The OCID of the compartment where you want to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:DataCatalog/getCatalogs:getCatalogs', __args__, opts=opts, typ=GetCatalogsResult).value

    return AwaitableGetCatalogsResult(
        catalogs=pulumi.get(__ret__, 'catalogs'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        filters=pulumi.get(__ret__, 'filters'),
        id=pulumi.get(__ret__, 'id'),
        state=pulumi.get(__ret__, 'state'))
def get_catalogs_output(compartment_id: Optional[pulumi.Input[str]] = None,
                        display_name: Optional[pulumi.Input[Optional[str]]] = None,
                        filters: Optional[pulumi.Input[Optional[Sequence[Union['GetCatalogsFilterArgs', 'GetCatalogsFilterArgsDict']]]]] = None,
                        state: Optional[pulumi.Input[Optional[str]]] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetCatalogsResult]:
    """
    This data source provides the list of Catalogs in Oracle Cloud Infrastructure Data Catalog service.

    Returns a list of all the data catalogs in the specified compartment.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_catalogs = oci.DataCatalog.get_catalogs(compartment_id=compartment_id,
        display_name=catalog_display_name,
        state=catalog_state)
    ```


    :param str compartment_id: The OCID of the compartment where you want to list resources.
    :param str display_name: A filter to return only resources that match the entire display name given. The match is not case sensitive.
    :param str state: A filter to return only resources that match the specified lifecycle state. The value is case insensitive.
    """
    __args__ = dict()
    __args__['compartmentId'] = compartment_id
    __args__['displayName'] = display_name
    __args__['filters'] = filters
    __args__['state'] = state
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:DataCatalog/getCatalogs:getCatalogs', __args__, opts=opts, typ=GetCatalogsResult)
    return __ret__.apply(lambda __response__: GetCatalogsResult(
        catalogs=pulumi.get(__response__, 'catalogs'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        filters=pulumi.get(__response__, 'filters'),
        id=pulumi.get(__response__, 'id'),
        state=pulumi.get(__response__, 'state')))
