# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetFleetPropertyResult',
    'AwaitableGetFleetPropertyResult',
    'get_fleet_property',
    'get_fleet_property_output',
]

@pulumi.output_type
class GetFleetPropertyResult:
    """
    A collection of values returned by getFleetProperty.
    """
    def __init__(__self__, allowed_values=None, compartment_id=None, display_name=None, fleet_id=None, fleet_property_id=None, id=None, property_id=None, selection_type=None, state=None, system_tags=None, time_created=None, time_updated=None, value=None, value_type=None):
        if allowed_values and not isinstance(allowed_values, list):
            raise TypeError("Expected argument 'allowed_values' to be a list")
        pulumi.set(__self__, "allowed_values", allowed_values)
        if compartment_id and not isinstance(compartment_id, str):
            raise TypeError("Expected argument 'compartment_id' to be a str")
        pulumi.set(__self__, "compartment_id", compartment_id)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if fleet_id and not isinstance(fleet_id, str):
            raise TypeError("Expected argument 'fleet_id' to be a str")
        pulumi.set(__self__, "fleet_id", fleet_id)
        if fleet_property_id and not isinstance(fleet_property_id, str):
            raise TypeError("Expected argument 'fleet_property_id' to be a str")
        pulumi.set(__self__, "fleet_property_id", fleet_property_id)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if property_id and not isinstance(property_id, str):
            raise TypeError("Expected argument 'property_id' to be a str")
        pulumi.set(__self__, "property_id", property_id)
        if selection_type and not isinstance(selection_type, str):
            raise TypeError("Expected argument 'selection_type' to be a str")
        pulumi.set(__self__, "selection_type", selection_type)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if system_tags and not isinstance(system_tags, dict):
            raise TypeError("Expected argument 'system_tags' to be a dict")
        pulumi.set(__self__, "system_tags", system_tags)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)
        if time_updated and not isinstance(time_updated, str):
            raise TypeError("Expected argument 'time_updated' to be a str")
        pulumi.set(__self__, "time_updated", time_updated)
        if value and not isinstance(value, str):
            raise TypeError("Expected argument 'value' to be a str")
        pulumi.set(__self__, "value", value)
        if value_type and not isinstance(value_type, str):
            raise TypeError("Expected argument 'value_type' to be a str")
        pulumi.set(__self__, "value_type", value_type)

    @property
    @pulumi.getter(name="allowedValues")
    def allowed_values(self) -> Sequence[str]:
        """
        Values of the category (must be a single value if selection = 'single choice')
        """
        return pulumi.get(self, "allowed_values")

    @property
    @pulumi.getter(name="compartmentId")
    def compartment_id(self) -> str:
        """
        Tenancy OCID
        """
        return pulumi.get(self, "compartment_id")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. Does not have to be unique, and it's changeable. Avoid entering confidential information.  Example: `My new resource`
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="fleetId")
    def fleet_id(self) -> str:
        return pulumi.get(self, "fleet_id")

    @property
    @pulumi.getter(name="fleetPropertyId")
    def fleet_property_id(self) -> str:
        return pulumi.get(self, "fleet_property_id")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The unique id of the resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="propertyId")
    def property_id(self) -> str:
        """
        Property Id Ocid.
        """
        return pulumi.get(self, "property_id")

    @property
    @pulumi.getter(name="selectionType")
    def selection_type(self) -> str:
        """
        Text selection of the category
        """
        return pulumi.get(self, "selection_type")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the FleetProperty.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="systemTags")
    def system_tags(self) -> Mapping[str, str]:
        """
        System tags for this resource. Each key is predefined and scoped to a namespace. Example: `{"orcl-cloud.free-tier-retained": "true"}`
        """
        return pulumi.get(self, "system_tags")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The time this resource was created. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_created")

    @property
    @pulumi.getter(name="timeUpdated")
    def time_updated(self) -> str:
        """
        The time this resource was last updated. An RFC3339 formatted datetime string.
        """
        return pulumi.get(self, "time_updated")

    @property
    @pulumi.getter
    def value(self) -> str:
        """
        Value of the Property
        """
        return pulumi.get(self, "value")

    @property
    @pulumi.getter(name="valueType")
    def value_type(self) -> str:
        """
        Format of the value
        """
        return pulumi.get(self, "value_type")


class AwaitableGetFleetPropertyResult(GetFleetPropertyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetFleetPropertyResult(
            allowed_values=self.allowed_values,
            compartment_id=self.compartment_id,
            display_name=self.display_name,
            fleet_id=self.fleet_id,
            fleet_property_id=self.fleet_property_id,
            id=self.id,
            property_id=self.property_id,
            selection_type=self.selection_type,
            state=self.state,
            system_tags=self.system_tags,
            time_created=self.time_created,
            time_updated=self.time_updated,
            value=self.value,
            value_type=self.value_type)


def get_fleet_property(fleet_id: Optional[str] = None,
                       fleet_property_id: Optional[str] = None,
                       opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetFleetPropertyResult:
    """
    This data source provides details about a specific Fleet Property resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a FleetProperty by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_property = oci.FleetAppsManagement.get_fleet_property(fleet_id=test_fleet["id"],
        fleet_property_id=test_property["id"])
    ```


    :param str fleet_id: unique Fleet identifier
    :param str fleet_property_id: unique FleetProperty identifier
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    __args__['fleetPropertyId'] = fleet_property_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:FleetAppsManagement/getFleetProperty:getFleetProperty', __args__, opts=opts, typ=GetFleetPropertyResult).value

    return AwaitableGetFleetPropertyResult(
        allowed_values=pulumi.get(__ret__, 'allowed_values'),
        compartment_id=pulumi.get(__ret__, 'compartment_id'),
        display_name=pulumi.get(__ret__, 'display_name'),
        fleet_id=pulumi.get(__ret__, 'fleet_id'),
        fleet_property_id=pulumi.get(__ret__, 'fleet_property_id'),
        id=pulumi.get(__ret__, 'id'),
        property_id=pulumi.get(__ret__, 'property_id'),
        selection_type=pulumi.get(__ret__, 'selection_type'),
        state=pulumi.get(__ret__, 'state'),
        system_tags=pulumi.get(__ret__, 'system_tags'),
        time_created=pulumi.get(__ret__, 'time_created'),
        time_updated=pulumi.get(__ret__, 'time_updated'),
        value=pulumi.get(__ret__, 'value'),
        value_type=pulumi.get(__ret__, 'value_type'))
def get_fleet_property_output(fleet_id: Optional[pulumi.Input[str]] = None,
                              fleet_property_id: Optional[pulumi.Input[str]] = None,
                              opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetFleetPropertyResult]:
    """
    This data source provides details about a specific Fleet Property resource in Oracle Cloud Infrastructure Fleet Apps Management service.

    Gets a FleetProperty by identifier

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_fleet_property = oci.FleetAppsManagement.get_fleet_property(fleet_id=test_fleet["id"],
        fleet_property_id=test_property["id"])
    ```


    :param str fleet_id: unique Fleet identifier
    :param str fleet_property_id: unique FleetProperty identifier
    """
    __args__ = dict()
    __args__['fleetId'] = fleet_id
    __args__['fleetPropertyId'] = fleet_property_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:FleetAppsManagement/getFleetProperty:getFleetProperty', __args__, opts=opts, typ=GetFleetPropertyResult)
    return __ret__.apply(lambda __response__: GetFleetPropertyResult(
        allowed_values=pulumi.get(__response__, 'allowed_values'),
        compartment_id=pulumi.get(__response__, 'compartment_id'),
        display_name=pulumi.get(__response__, 'display_name'),
        fleet_id=pulumi.get(__response__, 'fleet_id'),
        fleet_property_id=pulumi.get(__response__, 'fleet_property_id'),
        id=pulumi.get(__response__, 'id'),
        property_id=pulumi.get(__response__, 'property_id'),
        selection_type=pulumi.get(__response__, 'selection_type'),
        state=pulumi.get(__response__, 'state'),
        system_tags=pulumi.get(__response__, 'system_tags'),
        time_created=pulumi.get(__response__, 'time_created'),
        time_updated=pulumi.get(__response__, 'time_updated'),
        value=pulumi.get(__response__, 'value'),
        value_type=pulumi.get(__response__, 'value_type')))
