# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetConnectorPluginResult',
    'AwaitableGetConnectorPluginResult',
    'get_connector_plugin',
    'get_connector_plugin_output',
]

@pulumi.output_type
class GetConnectorPluginResult:
    """
    A collection of values returned by getConnectorPlugin.
    """
    def __init__(__self__, connector_plugin_name=None, display_name=None, estimated_throughput=None, id=None, kind=None, max_retention=None, name=None, schema=None, state=None, time_created=None):
        if connector_plugin_name and not isinstance(connector_plugin_name, str):
            raise TypeError("Expected argument 'connector_plugin_name' to be a str")
        pulumi.set(__self__, "connector_plugin_name", connector_plugin_name)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if estimated_throughput and not isinstance(estimated_throughput, str):
            raise TypeError("Expected argument 'estimated_throughput' to be a str")
        pulumi.set(__self__, "estimated_throughput", estimated_throughput)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if max_retention and not isinstance(max_retention, str):
            raise TypeError("Expected argument 'max_retention' to be a str")
        pulumi.set(__self__, "max_retention", max_retention)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if schema and not isinstance(schema, str):
            raise TypeError("Expected argument 'schema' to be a str")
        pulumi.set(__self__, "schema", schema)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if time_created and not isinstance(time_created, str):
            raise TypeError("Expected argument 'time_created' to be a str")
        pulumi.set(__self__, "time_created", time_created)

    @property
    @pulumi.getter(name="connectorPluginName")
    def connector_plugin_name(self) -> str:
        return pulumi.get(self, "connector_plugin_name")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        A user-friendly name. It does not have to be unique, and it is changeable. Avoid entering confidential information.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter(name="estimatedThroughput")
    def estimated_throughput(self) -> str:
        """
        The estimated throughput range (LOW, MEDIUM, HIGH).
        """
        return pulumi.get(self, "estimated_throughput")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The plugin type discriminator.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter(name="maxRetention")
    def max_retention(self) -> str:
        """
        The estimated maximum period of time the data will be kept at the source. The duration is specified as a string in ISO 8601 format (P1D for one day or P30D for thrity days).
        """
        return pulumi.get(self, "max_retention")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The service to be called by the connector plugin. Example: `QueueSource`
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def schema(self) -> str:
        """
        Gets the specified connector plugin configuration information in OpenAPI specification format.
        """
        return pulumi.get(self, "schema")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the service connector.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="timeCreated")
    def time_created(self) -> str:
        """
        The date and time when this plugin became available. Format is defined by [RFC3339](https://tools.ietf.org/html/rfc3339). Example: `2023-09-09T21:10:29.600Z`
        """
        return pulumi.get(self, "time_created")


class AwaitableGetConnectorPluginResult(GetConnectorPluginResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConnectorPluginResult(
            connector_plugin_name=self.connector_plugin_name,
            display_name=self.display_name,
            estimated_throughput=self.estimated_throughput,
            id=self.id,
            kind=self.kind,
            max_retention=self.max_retention,
            name=self.name,
            schema=self.schema,
            state=self.state,
            time_created=self.time_created)


def get_connector_plugin(connector_plugin_name: Optional[str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConnectorPluginResult:
    """
    This data source provides details about a specific Connector Plugin resource in Oracle Cloud Infrastructure Service Connector Hub service.

    Gets the specified connector plugin configuration information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connector_plugin = oci.Sch.get_connector_plugin(connector_plugin_name=test_connector_plugin_oci_sch_connector_plugin["name"])
    ```


    :param str connector_plugin_name: The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service.
    """
    __args__ = dict()
    __args__['connectorPluginName'] = connector_plugin_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('oci:Sch/getConnectorPlugin:getConnectorPlugin', __args__, opts=opts, typ=GetConnectorPluginResult).value

    return AwaitableGetConnectorPluginResult(
        connector_plugin_name=pulumi.get(__ret__, 'connector_plugin_name'),
        display_name=pulumi.get(__ret__, 'display_name'),
        estimated_throughput=pulumi.get(__ret__, 'estimated_throughput'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        max_retention=pulumi.get(__ret__, 'max_retention'),
        name=pulumi.get(__ret__, 'name'),
        schema=pulumi.get(__ret__, 'schema'),
        state=pulumi.get(__ret__, 'state'),
        time_created=pulumi.get(__ret__, 'time_created'))
def get_connector_plugin_output(connector_plugin_name: Optional[pulumi.Input[str]] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConnectorPluginResult]:
    """
    This data source provides details about a specific Connector Plugin resource in Oracle Cloud Infrastructure Service Connector Hub service.

    Gets the specified connector plugin configuration information.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_oci as oci

    test_connector_plugin = oci.Sch.get_connector_plugin(connector_plugin_name=test_connector_plugin_oci_sch_connector_plugin["name"])
    ```


    :param str connector_plugin_name: The name of the connector plugin. This name indicates the service to be called by the connector plugin. For example, `QueueSource` indicates the Queue service.
    """
    __args__ = dict()
    __args__['connectorPluginName'] = connector_plugin_name
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('oci:Sch/getConnectorPlugin:getConnectorPlugin', __args__, opts=opts, typ=GetConnectorPluginResult)
    return __ret__.apply(lambda __response__: GetConnectorPluginResult(
        connector_plugin_name=pulumi.get(__response__, 'connector_plugin_name'),
        display_name=pulumi.get(__response__, 'display_name'),
        estimated_throughput=pulumi.get(__response__, 'estimated_throughput'),
        id=pulumi.get(__response__, 'id'),
        kind=pulumi.get(__response__, 'kind'),
        max_retention=pulumi.get(__response__, 'max_retention'),
        name=pulumi.get(__response__, 'name'),
        schema=pulumi.get(__response__, 'schema'),
        state=pulumi.get(__response__, 'state'),
        time_created=pulumi.get(__response__, 'time_created')))
