# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities

__all__ = ['CameraVideoSettingsArgs', 'CameraVideoSettings']

@pulumi.input_type
class CameraVideoSettingsArgs:
    def __init__(__self__, *,
                 serial: pulumi.Input[str],
                 external_rtsp_enabled: Optional[pulumi.Input[bool]] = None):
        """
        The set of arguments for constructing a CameraVideoSettings resource.
        :param pulumi.Input[str] serial: serial path parameter.
        :param pulumi.Input[bool] external_rtsp_enabled: Boolean indicating if external rtsp stream is exposed
        """
        pulumi.set(__self__, "serial", serial)
        if external_rtsp_enabled is not None:
            pulumi.set(__self__, "external_rtsp_enabled", external_rtsp_enabled)

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Input[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: pulumi.Input[str]):
        pulumi.set(self, "serial", value)

    @property
    @pulumi.getter(name="externalRtspEnabled")
    def external_rtsp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating if external rtsp stream is exposed
        """
        return pulumi.get(self, "external_rtsp_enabled")

    @external_rtsp_enabled.setter
    def external_rtsp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external_rtsp_enabled", value)


@pulumi.input_type
class _CameraVideoSettingsState:
    def __init__(__self__, *,
                 external_rtsp_enabled: Optional[pulumi.Input[bool]] = None,
                 rtsp_url: Optional[pulumi.Input[str]] = None,
                 serial: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CameraVideoSettings resources.
        :param pulumi.Input[bool] external_rtsp_enabled: Boolean indicating if external rtsp stream is exposed
        :param pulumi.Input[str] rtsp_url: External rstp url. Will only be returned if external rtsp stream is exposed
        :param pulumi.Input[str] serial: serial path parameter.
        """
        if external_rtsp_enabled is not None:
            pulumi.set(__self__, "external_rtsp_enabled", external_rtsp_enabled)
        if rtsp_url is not None:
            pulumi.set(__self__, "rtsp_url", rtsp_url)
        if serial is not None:
            pulumi.set(__self__, "serial", serial)

    @property
    @pulumi.getter(name="externalRtspEnabled")
    def external_rtsp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean indicating if external rtsp stream is exposed
        """
        return pulumi.get(self, "external_rtsp_enabled")

    @external_rtsp_enabled.setter
    def external_rtsp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "external_rtsp_enabled", value)

    @property
    @pulumi.getter(name="rtspUrl")
    def rtsp_url(self) -> Optional[pulumi.Input[str]]:
        """
        External rstp url. Will only be returned if external rtsp stream is exposed
        """
        return pulumi.get(self, "rtsp_url")

    @rtsp_url.setter
    def rtsp_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rtsp_url", value)

    @property
    @pulumi.getter
    def serial(self) -> Optional[pulumi.Input[str]]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

    @serial.setter
    def serial(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "serial", value)


class CameraVideoSettings(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_rtsp_enabled: Optional[pulumi.Input[bool]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CameraVideoSettings("example",
            external_rtsp_enabled=True,
            serial="string")
        pulumi.export("merakiDevicesCameraVideoSettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cameraVideoSettings:CameraVideoSettings example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] external_rtsp_enabled: Boolean indicating if external rtsp stream is exposed
        :param pulumi.Input[str] serial: serial path parameter.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CameraVideoSettingsArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.devices.CameraVideoSettings("example",
            external_rtsp_enabled=True,
            serial="string")
        pulumi.export("merakiDevicesCameraVideoSettingsExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:devices/cameraVideoSettings:CameraVideoSettings example "serial"
        ```

        :param str resource_name: The name of the resource.
        :param CameraVideoSettingsArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CameraVideoSettingsArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 external_rtsp_enabled: Optional[pulumi.Input[bool]] = None,
                 serial: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CameraVideoSettingsArgs.__new__(CameraVideoSettingsArgs)

            __props__.__dict__["external_rtsp_enabled"] = external_rtsp_enabled
            if serial is None and not opts.urn:
                raise TypeError("Missing required property 'serial'")
            __props__.__dict__["serial"] = serial
            __props__.__dict__["rtsp_url"] = None
        super(CameraVideoSettings, __self__).__init__(
            'meraki:devices/cameraVideoSettings:CameraVideoSettings',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            external_rtsp_enabled: Optional[pulumi.Input[bool]] = None,
            rtsp_url: Optional[pulumi.Input[str]] = None,
            serial: Optional[pulumi.Input[str]] = None) -> 'CameraVideoSettings':
        """
        Get an existing CameraVideoSettings resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[bool] external_rtsp_enabled: Boolean indicating if external rtsp stream is exposed
        :param pulumi.Input[str] rtsp_url: External rstp url. Will only be returned if external rtsp stream is exposed
        :param pulumi.Input[str] serial: serial path parameter.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CameraVideoSettingsState.__new__(_CameraVideoSettingsState)

        __props__.__dict__["external_rtsp_enabled"] = external_rtsp_enabled
        __props__.__dict__["rtsp_url"] = rtsp_url
        __props__.__dict__["serial"] = serial
        return CameraVideoSettings(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="externalRtspEnabled")
    def external_rtsp_enabled(self) -> pulumi.Output[bool]:
        """
        Boolean indicating if external rtsp stream is exposed
        """
        return pulumi.get(self, "external_rtsp_enabled")

    @property
    @pulumi.getter(name="rtspUrl")
    def rtsp_url(self) -> pulumi.Output[str]:
        """
        External rstp url. Will only be returned if external rtsp stream is exposed
        """
        return pulumi.get(self, "rtsp_url")

    @property
    @pulumi.getter
    def serial(self) -> pulumi.Output[str]:
        """
        serial path parameter.
        """
        return pulumi.get(self, "serial")

