# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrafficAnalysisArgs', 'TrafficAnalysis']

@pulumi.input_type
class TrafficAnalysisArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 custom_pie_chart_items: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficAnalysisCustomPieChartItemArgs']]]] = None,
                 mode: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a TrafficAnalysis resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[Sequence[pulumi.Input['TrafficAnalysisCustomPieChartItemArgs']]] custom_pie_chart_items: The list of items that make up the custom pie chart for traffic reporting.
        :param pulumi.Input[str] mode: The traffic analysis mode for the network. Can be one of 'disabled' (do not collect traffic types),
               'basic' (collect generic traffic categories), or 'detailed' (collect destination hostnames).
        """
        pulumi.set(__self__, "network_id", network_id)
        if custom_pie_chart_items is not None:
            pulumi.set(__self__, "custom_pie_chart_items", custom_pie_chart_items)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="customPieChartItems")
    def custom_pie_chart_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficAnalysisCustomPieChartItemArgs']]]]:
        """
        The list of items that make up the custom pie chart for traffic reporting.
        """
        return pulumi.get(self, "custom_pie_chart_items")

    @custom_pie_chart_items.setter
    def custom_pie_chart_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficAnalysisCustomPieChartItemArgs']]]]):
        pulumi.set(self, "custom_pie_chart_items", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The traffic analysis mode for the network. Can be one of 'disabled' (do not collect traffic types),
        'basic' (collect generic traffic categories), or 'detailed' (collect destination hostnames).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)


@pulumi.input_type
class _TrafficAnalysisState:
    def __init__(__self__, *,
                 custom_pie_chart_items: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficAnalysisCustomPieChartItemArgs']]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering TrafficAnalysis resources.
        :param pulumi.Input[Sequence[pulumi.Input['TrafficAnalysisCustomPieChartItemArgs']]] custom_pie_chart_items: The list of items that make up the custom pie chart for traffic reporting.
        :param pulumi.Input[str] mode: The traffic analysis mode for the network. Can be one of 'disabled' (do not collect traffic types),
               'basic' (collect generic traffic categories), or 'detailed' (collect destination hostnames).
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        if custom_pie_chart_items is not None:
            pulumi.set(__self__, "custom_pie_chart_items", custom_pie_chart_items)
        if mode is not None:
            pulumi.set(__self__, "mode", mode)
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)

    @property
    @pulumi.getter(name="customPieChartItems")
    def custom_pie_chart_items(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrafficAnalysisCustomPieChartItemArgs']]]]:
        """
        The list of items that make up the custom pie chart for traffic reporting.
        """
        return pulumi.get(self, "custom_pie_chart_items")

    @custom_pie_chart_items.setter
    def custom_pie_chart_items(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrafficAnalysisCustomPieChartItemArgs']]]]):
        pulumi.set(self, "custom_pie_chart_items", value)

    @property
    @pulumi.getter
    def mode(self) -> Optional[pulumi.Input[str]]:
        """
        The traffic analysis mode for the network. Can be one of 'disabled' (do not collect traffic types),
        'basic' (collect generic traffic categories), or 'detailed' (collect destination hostnames).
        """
        return pulumi.get(self, "mode")

    @mode.setter
    def mode(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "mode", value)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)


class TrafficAnalysis(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_pie_chart_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficAnalysisCustomPieChartItemArgs', 'TrafficAnalysisCustomPieChartItemArgsDict']]]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.TrafficAnalysis("example",
            custom_pie_chart_items=[{
                "name": "Item from hostname",
                "type": "host",
                "value": "example.com",
            }],
            mode="disabled",
            network_id="string")
        pulumi.export("merakiNetworksTrafficAnalysisExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/trafficAnalysis:TrafficAnalysis example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficAnalysisCustomPieChartItemArgs', 'TrafficAnalysisCustomPieChartItemArgsDict']]]] custom_pie_chart_items: The list of items that make up the custom pie chart for traffic reporting.
        :param pulumi.Input[str] mode: The traffic analysis mode for the network. Can be one of 'disabled' (do not collect traffic types),
               'basic' (collect generic traffic categories), or 'detailed' (collect destination hostnames).
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrafficAnalysisArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_meraki as meraki

        example = meraki.networks.TrafficAnalysis("example",
            custom_pie_chart_items=[{
                "name": "Item from hostname",
                "type": "host",
                "value": "example.com",
            }],
            mode="disabled",
            network_id="string")
        pulumi.export("merakiNetworksTrafficAnalysisExample", example)
        ```

        ## Import

        ```sh
        $ pulumi import meraki:networks/trafficAnalysis:TrafficAnalysis example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param TrafficAnalysisArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrafficAnalysisArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 custom_pie_chart_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficAnalysisCustomPieChartItemArgs', 'TrafficAnalysisCustomPieChartItemArgsDict']]]]] = None,
                 mode: Optional[pulumi.Input[str]] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrafficAnalysisArgs.__new__(TrafficAnalysisArgs)

            __props__.__dict__["custom_pie_chart_items"] = custom_pie_chart_items
            __props__.__dict__["mode"] = mode
            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
        super(TrafficAnalysis, __self__).__init__(
            'meraki:networks/trafficAnalysis:TrafficAnalysis',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            custom_pie_chart_items: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrafficAnalysisCustomPieChartItemArgs', 'TrafficAnalysisCustomPieChartItemArgsDict']]]]] = None,
            mode: Optional[pulumi.Input[str]] = None,
            network_id: Optional[pulumi.Input[str]] = None) -> 'TrafficAnalysis':
        """
        Get an existing TrafficAnalysis resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrafficAnalysisCustomPieChartItemArgs', 'TrafficAnalysisCustomPieChartItemArgsDict']]]] custom_pie_chart_items: The list of items that make up the custom pie chart for traffic reporting.
        :param pulumi.Input[str] mode: The traffic analysis mode for the network. Can be one of 'disabled' (do not collect traffic types),
               'basic' (collect generic traffic categories), or 'detailed' (collect destination hostnames).
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrafficAnalysisState.__new__(_TrafficAnalysisState)

        __props__.__dict__["custom_pie_chart_items"] = custom_pie_chart_items
        __props__.__dict__["mode"] = mode
        __props__.__dict__["network_id"] = network_id
        return TrafficAnalysis(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="customPieChartItems")
    def custom_pie_chart_items(self) -> pulumi.Output[Sequence['outputs.TrafficAnalysisCustomPieChartItem']]:
        """
        The list of items that make up the custom pie chart for traffic reporting.
        """
        return pulumi.get(self, "custom_pie_chart_items")

    @property
    @pulumi.getter
    def mode(self) -> pulumi.Output[str]:
        """
        The traffic analysis mode for the network. Can be one of 'disabled' (do not collect traffic types),
        'basic' (collect generic traffic categories), or 'detailed' (collect destination hostnames).
        """
        return pulumi.get(self, "mode")

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

