# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SwitchStpArgs', 'SwitchStp']

@pulumi.input_type
class SwitchStpArgs:
    def __init__(__self__, *,
                 network_id: pulumi.Input[str],
                 rstp_enabled: Optional[pulumi.Input[bool]] = None,
                 stp_bridge_priorities: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityArgs']]]] = None):
        """
        The set of arguments for constructing a SwitchStp resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] rstp_enabled: The spanning tree protocol status in network
        :param pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityArgs']]] stp_bridge_priorities: STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        """
        pulumi.set(__self__, "network_id", network_id)
        if rstp_enabled is not None:
            pulumi.set(__self__, "rstp_enabled", rstp_enabled)
        if stp_bridge_priorities is not None:
            pulumi.set(__self__, "stp_bridge_priorities", stp_bridge_priorities)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Input[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: pulumi.Input[str]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="rstpEnabled")
    def rstp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The spanning tree protocol status in network
        """
        return pulumi.get(self, "rstp_enabled")

    @rstp_enabled.setter
    def rstp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rstp_enabled", value)

    @property
    @pulumi.getter(name="stpBridgePriorities")
    def stp_bridge_priorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityArgs']]]]:
        """
        STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        """
        return pulumi.get(self, "stp_bridge_priorities")

    @stp_bridge_priorities.setter
    def stp_bridge_priorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityArgs']]]]):
        pulumi.set(self, "stp_bridge_priorities", value)


@pulumi.input_type
class _SwitchStpState:
    def __init__(__self__, *,
                 network_id: Optional[pulumi.Input[str]] = None,
                 rstp_enabled: Optional[pulumi.Input[bool]] = None,
                 stp_bridge_priorities: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityArgs']]]] = None,
                 stp_bridge_priority_responses: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityResponseArgs']]]] = None):
        """
        Input properties used for looking up and filtering SwitchStp resources.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] rstp_enabled: The spanning tree protocol status in network
        :param pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityArgs']]] stp_bridge_priorities: STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        :param pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityResponseArgs']]] stp_bridge_priority_responses: STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        """
        if network_id is not None:
            pulumi.set(__self__, "network_id", network_id)
        if rstp_enabled is not None:
            pulumi.set(__self__, "rstp_enabled", rstp_enabled)
        if stp_bridge_priorities is not None:
            pulumi.set(__self__, "stp_bridge_priorities", stp_bridge_priorities)
        if stp_bridge_priority_responses is not None:
            pulumi.set(__self__, "stp_bridge_priority_responses", stp_bridge_priority_responses)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> Optional[pulumi.Input[str]]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @network_id.setter
    def network_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "network_id", value)

    @property
    @pulumi.getter(name="rstpEnabled")
    def rstp_enabled(self) -> Optional[pulumi.Input[bool]]:
        """
        The spanning tree protocol status in network
        """
        return pulumi.get(self, "rstp_enabled")

    @rstp_enabled.setter
    def rstp_enabled(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "rstp_enabled", value)

    @property
    @pulumi.getter(name="stpBridgePriorities")
    def stp_bridge_priorities(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityArgs']]]]:
        """
        STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        """
        return pulumi.get(self, "stp_bridge_priorities")

    @stp_bridge_priorities.setter
    def stp_bridge_priorities(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityArgs']]]]):
        pulumi.set(self, "stp_bridge_priorities", value)

    @property
    @pulumi.getter(name="stpBridgePriorityResponses")
    def stp_bridge_priority_responses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityResponseArgs']]]]:
        """
        STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        """
        return pulumi.get(self, "stp_bridge_priority_responses")

    @stp_bridge_priority_responses.setter
    def stp_bridge_priority_responses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SwitchStpStpBridgePriorityResponseArgs']]]]):
        pulumi.set(self, "stp_bridge_priority_responses", value)


class SwitchStp(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 rstp_enabled: Optional[pulumi.Input[bool]] = None,
                 stp_bridge_priorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStpStpBridgePriorityArgs', 'SwitchStpStpBridgePriorityArgsDict']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStp:SwitchStp example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] rstp_enabled: The spanning tree protocol status in network
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchStpStpBridgePriorityArgs', 'SwitchStpStpBridgePriorityArgsDict']]]] stp_bridge_priorities: STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SwitchStpArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ## Import

        ```sh
        $ pulumi import meraki:networks/switchStp:SwitchStp example "network_id"
        ```

        :param str resource_name: The name of the resource.
        :param SwitchStpArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SwitchStpArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 network_id: Optional[pulumi.Input[str]] = None,
                 rstp_enabled: Optional[pulumi.Input[bool]] = None,
                 stp_bridge_priorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStpStpBridgePriorityArgs', 'SwitchStpStpBridgePriorityArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SwitchStpArgs.__new__(SwitchStpArgs)

            if network_id is None and not opts.urn:
                raise TypeError("Missing required property 'network_id'")
            __props__.__dict__["network_id"] = network_id
            __props__.__dict__["rstp_enabled"] = rstp_enabled
            __props__.__dict__["stp_bridge_priorities"] = stp_bridge_priorities
            __props__.__dict__["stp_bridge_priority_responses"] = None
        super(SwitchStp, __self__).__init__(
            'meraki:networks/switchStp:SwitchStp',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            network_id: Optional[pulumi.Input[str]] = None,
            rstp_enabled: Optional[pulumi.Input[bool]] = None,
            stp_bridge_priorities: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStpStpBridgePriorityArgs', 'SwitchStpStpBridgePriorityArgsDict']]]]] = None,
            stp_bridge_priority_responses: Optional[pulumi.Input[Sequence[pulumi.Input[Union['SwitchStpStpBridgePriorityResponseArgs', 'SwitchStpStpBridgePriorityResponseArgsDict']]]]] = None) -> 'SwitchStp':
        """
        Get an existing SwitchStp resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] network_id: networkId path parameter. Network ID
        :param pulumi.Input[bool] rstp_enabled: The spanning tree protocol status in network
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchStpStpBridgePriorityArgs', 'SwitchStpStpBridgePriorityArgsDict']]]] stp_bridge_priorities: STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        :param pulumi.Input[Sequence[pulumi.Input[Union['SwitchStpStpBridgePriorityResponseArgs', 'SwitchStpStpBridgePriorityResponseArgsDict']]]] stp_bridge_priority_responses: STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SwitchStpState.__new__(_SwitchStpState)

        __props__.__dict__["network_id"] = network_id
        __props__.__dict__["rstp_enabled"] = rstp_enabled
        __props__.__dict__["stp_bridge_priorities"] = stp_bridge_priorities
        __props__.__dict__["stp_bridge_priority_responses"] = stp_bridge_priority_responses
        return SwitchStp(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="networkId")
    def network_id(self) -> pulumi.Output[str]:
        """
        networkId path parameter. Network ID
        """
        return pulumi.get(self, "network_id")

    @property
    @pulumi.getter(name="rstpEnabled")
    def rstp_enabled(self) -> pulumi.Output[bool]:
        """
        The spanning tree protocol status in network
        """
        return pulumi.get(self, "rstp_enabled")

    @property
    @pulumi.getter(name="stpBridgePriorities")
    def stp_bridge_priorities(self) -> pulumi.Output[Optional[Sequence['outputs.SwitchStpStpBridgePriority']]]:
        """
        STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        """
        return pulumi.get(self, "stp_bridge_priorities")

    @property
    @pulumi.getter(name="stpBridgePriorityResponses")
    def stp_bridge_priority_responses(self) -> pulumi.Output[Sequence['outputs.SwitchStpStpBridgePriorityResponse']]:
        """
        STP bridge priority for switches/stacks or switch templates. An empty array will clear the STP bridge priority settings.
        """
        return pulumi.get(self, "stp_bridge_priority_responses")

