# coding: utf-8

"""
    Cashfree LRS

    CashFree LRS APIs (v2)  # noqa: E501

    The version of the OpenAPI document: 1.0.12
    Contact: nextgenapi@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional
from pydantic import BaseModel, Field, constr
from cashfree_lrs_client.models.country import Country

class CreateBeneficiaryRequest(BaseModel):
    """
    CreateBeneficiaryRequest
    """
    beneficiary_id: constr(strict=True, max_length=50, min_length=1) = Field(..., description="Unique Beneficiary ID to identify the beneficiary. Alphanumeric characters and underscores are allowed. Maximum of 50 characters is allowed.")
    account_holder_name: constr(strict=True, max_length=50, min_length=3) = Field(..., description="Name of the beneficiary. Only alphabets are allowed.")
    account_number: constr(strict=True, max_length=25, min_length=9) = Field(..., description="Bank account number of the beneficiary. 9 - 25 alphanumeric characters are allowed.")
    swift_code: constr(strict=True, max_length=11, min_length=8) = Field(..., description="8 to 11 character code in which first 6 characters are uppercase alphabets and the remaining are alphanumeric characters.")
    iban: Optional[constr(strict=True, max_length=40, min_length=18)] = Field(None, description="IBAN of the beneficiary account.")
    routing_number: Optional[constr(strict=True, max_length=9, min_length=9)] = Field(None, description="9 digits routing number.")
    bank_name: constr(strict=True, max_length=50, min_length=3) = Field(..., description="Bank name of the beneficiary where the account exists.")
    bank_address: constr(strict=True, max_length=200, min_length=3) = Field(..., description="Bank address of the beneficiary where the account exists.")
    bank_country: Country = Field(...)
    sort_code: Optional[constr(strict=True, max_length=15, min_length=1)] = Field(None, description="Sort code of the country. Only numbers and hyphens are allowed.")
    transit_code: Optional[constr(strict=True, max_length=10, min_length=5)] = Field(None, description="Transit code which consists of numbers between 5 to 10 in length.")
    bsb_number: Optional[constr(strict=True, max_length=6, min_length=6)] = Field(None, description="BSB number is a 6 digit number code.")
    address: constr(strict=True, max_length=200, min_length=3) = Field(..., description="Address of the beneficiary. Only address alphanumeric characters, comma, dot, hyphens, and spaces are allowed. Maximum of 2000 charcaters is allowed.")
    city: constr(strict=True, max_length=200, min_length=3) = Field(..., description="City in which the beneficiary resides. Only alphabets are allowed.")
    state: constr(strict=True, max_length=200, min_length=3) = Field(..., description="State in which the beneficiary resides. Only alphabets are allowed.")
    country: Country = Field(...)
    postal_code: constr(strict=True, max_length=15, min_length=1) = Field(..., description="Postal code of the beneficiary. Only alphanumeric characters are allowed. A maximum of 15 charcaters is allowed.")
    __properties = ["beneficiary_id", "account_holder_name", "account_number", "swift_code", "iban", "routing_number", "bank_name", "bank_address", "bank_country", "sort_code", "transit_code", "bsb_number", "address", "city", "state", "country", "postal_code"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> CreateBeneficiaryRequest:
        """Create an instance of CreateBeneficiaryRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> CreateBeneficiaryRequest:
        """Create an instance of CreateBeneficiaryRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return CreateBeneficiaryRequest.parse_obj(obj)

        _obj = CreateBeneficiaryRequest.parse_obj({
            "beneficiary_id": obj.get("beneficiary_id"),
            "account_holder_name": obj.get("account_holder_name"),
            "account_number": obj.get("account_number"),
            "swift_code": obj.get("swift_code"),
            "iban": obj.get("iban"),
            "routing_number": obj.get("routing_number"),
            "bank_name": obj.get("bank_name"),
            "bank_address": obj.get("bank_address"),
            "bank_country": obj.get("bank_country"),
            "sort_code": obj.get("sort_code"),
            "transit_code": obj.get("transit_code"),
            "bsb_number": obj.get("bsb_number"),
            "address": obj.get("address"),
            "city": obj.get("city"),
            "state": obj.get("state"),
            "country": obj.get("country"),
            "postal_code": obj.get("postal_code")
        })
        return _obj

