# coding: utf-8

"""
    Cashfree LRS

    CashFree LRS APIs (v2)  # noqa: E501

    The version of the OpenAPI document: 1.0.12
    Contact: nextgenapi@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Optional, Union
from pydantic import BaseModel, Field, StrictBool, confloat, conint, constr
from cashfree_lrs_client.models.currency import Currency
from cashfree_lrs_client.models.purpose import Purpose

class FetchForexRateRequest(BaseModel):
    """
    
    """
    to_currency: Currency = Field(...)
    to_amount: Union[confloat(ge=0, strict=True), conint(ge=0, strict=True)] = Field(..., description="Final settlement amount in to_currency (Double with 2 decimals are allowed.)")
    purpose: Purpose = Field(...)
    remitter_id: Optional[constr(strict=True, max_length=50, min_length=3)] = Field(None, description="Unique remitter ID to identify the remitter. Alphanumeric characters, hyphens, and underscores are allowed. Maximum of 50 characters are allowed. If remitter ID is not specificed the tcs value calculated is zero.")
    customer_declaration: Optional[Union[confloat(ge=0, strict=True), conint(ge=0, strict=True)]] = Field(None, description="Amount in INR declared by Customer (Double with 2 decimals are allowed.)")
    education_loan: Optional[StrictBool] = Field(False, description="Whether user has availed an education loan")
    from_amount: Optional[Union[confloat(ge=0, strict=True), conint(ge=0, strict=True)]] = Field(None, description="Amount in INR, if passed will be used for calculation of FX_Rate")
    __properties = ["to_currency", "to_amount", "purpose", "remitter_id", "customer_declaration", "education_loan", "from_amount"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FetchForexRateRequest:
        """Create an instance of FetchForexRateRequest from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                          },
                          exclude_none=True)
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FetchForexRateRequest:
        """Create an instance of FetchForexRateRequest from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FetchForexRateRequest.parse_obj(obj)

        _obj = FetchForexRateRequest.parse_obj({
            "to_currency": obj.get("to_currency"),
            "to_amount": obj.get("to_amount"),
            "purpose": obj.get("purpose"),
            "remitter_id": obj.get("remitter_id"),
            "customer_declaration": obj.get("customer_declaration"),
            "education_loan": obj.get("education_loan") if obj.get("education_loan") is not None else False,
            "from_amount": obj.get("from_amount")
        })
        return _obj

