# coding: utf-8

"""
    Cashfree LRS

    CashFree LRS APIs (v2)  # noqa: E501

    The version of the OpenAPI document: 1.0.12
    Contact: nextgenapi@cashfree.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""


from __future__ import annotations
import pprint
import re  # noqa: F401
import json


from typing import Union
from pydantic import BaseModel, Field, StrictFloat, StrictInt
from cashfree_lrs_client.models.fetch_forex_rate_response_tcs import FetchForexRateResponseTcs

class FetchForexRateResponse(BaseModel):
    """
    
    """
    tcs: FetchForexRateResponseTcs = Field(...)
    gst: Union[StrictFloat, StrictInt] = Field(...)
    to_amount: Union[StrictFloat, StrictInt] = Field(...)
    fx_rate: Union[StrictFloat, StrictInt] = Field(...)
    amount_to_pay: Union[StrictFloat, StrictInt] = Field(...)
    handling_charges: Union[StrictFloat, StrictInt] = Field(...)
    __properties = ["tcs", "gst", "to_amount", "fx_rate", "amount_to_pay", "handling_charges"]

    class Config:
        """Pydantic configuration"""
        allow_population_by_field_name = True
        validate_assignment = True

    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.dict(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> FetchForexRateResponse:
        """Create an instance of FetchForexRateResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self):
        """Returns the dictionary representation of the model using alias"""
        _dict = self.dict(by_alias=True,
                          exclude={
                            "gst",
                            "to_amount",
                            "fx_rate",
                            "amount_to_pay",
                            "handling_charges",
                          },
                          exclude_none=True)
        # override the default output from pydantic by calling `to_dict()` of tcs
        if self.tcs:
            _dict['tcs'] = self.tcs.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: dict) -> FetchForexRateResponse:
        """Create an instance of FetchForexRateResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return FetchForexRateResponse.parse_obj(obj)

        _obj = FetchForexRateResponse.parse_obj({
            "tcs": FetchForexRateResponseTcs.from_dict(obj.get("tcs")) if obj.get("tcs") is not None else None,
            "gst": obj.get("gst"),
            "to_amount": obj.get("to_amount"),
            "fx_rate": obj.get("fx_rate"),
            "amount_to_pay": obj.get("amount_to_pay"),
            "handling_charges": obj.get("handling_charges")
        })
        return _obj

