/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.telemetry;

import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class Incident {
    private String project = null;
    private Map<String, String> environment = null;
    private Map<String, Object> exception = null;

    public String getProject() {
        return this.project;
    }

    public Incident setProject(String project) {
        this.project = Objects.requireNonNull(project);
        return this;
    }

    public Map<String, String> getEnvironment() {
        return this.environment;
    }

    public Incident setEnvironment(String environment) {
        return this.setEnvironment(Incident.formatEnvironment(environment));
    }

    public Incident setEnvironment(Map<String, String> environment) {
        this.environment = Objects.requireNonNull(environment);
        return this;
    }

    public Map<String, Object> getException() {
        return this.exception;
    }

    public Incident setException(Exception exception) {
        return this.setException(Incident.formatException(exception));
    }

    public Incident setException(Map<String, Object> exception) {
        this.exception = Objects.requireNonNull(exception);
        return this;
    }

    private static Map<String, String> formatEnvironment(String environment) {
        String[] lines;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String line : lines = environment.split("\n")) {
            if (Objects.equals("", line = line.trim())) continue;
            int sep = line.indexOf(61);
            String key = line.substring(0, sep).trim();
            String value = line.substring(sep + 1).trim();
            result.put(key, value);
        }
        return result;
    }

    private static Map<String, Object> formatException(Exception exception) {
        if (exception == null) {
            return null;
        }
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        result.put("class", exception.getClass().getName());
        result.put("message", exception.getMessage());
        result.put("stack_trace", Incident.formatStackTrace(exception.getStackTrace()));
        result.put("cause", Incident.formatException((Exception)exception.getCause()));
        return result;
    }

    private static List<String> formatStackTrace(StackTraceElement[] stackTraceElements) {
        return Arrays.stream(stackTraceElements).map(stackTraceElement -> {
            StringBuilder sb = new StringBuilder();
            String className = stackTraceElement.getClassName();
            String methodName = stackTraceElement.getMethodName();
            sb.append(className).append('.').append(methodName);
            if (stackTraceElement.isNativeMethod()) {
                sb.append("(Native Method)");
            } else {
                String fileName = stackTraceElement.getFileName();
                if (fileName != null) {
                    int lineNumber = stackTraceElement.getLineNumber();
                    sb.append('(').append(fileName);
                    if (lineNumber > -1) {
                        sb.append(':').append(lineNumber);
                    }
                    sb.append(')');
                } else {
                    sb.append("(Unknown Source)");
                }
            }
            return sb.toString();
        }).collect(Collectors.toList());
    }
}

