/*
 * Decompiled with CFR 0.152.
 */
package com.sklearn2pmml;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.sun.istack.logging.Logger;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.LogManager;
import org.dmg.pmml.PMML;
import org.dmg.pmml.PMMLObject;
import org.dmg.pmml.Version;
import org.dmg.pmml.Visitable;
import org.jpmml.converter.Application;
import org.jpmml.converter.VersionConverter;
import org.jpmml.model.MarkupException;
import org.jpmml.model.PMMLOutputStream;
import org.jpmml.model.metro.MetroJAXBSerializer;
import org.jpmml.model.visitors.VersionChecker;
import org.jpmml.model.visitors.VersionDowngrader;
import org.jpmml.model.visitors.VersionStandardizer;
import org.jpmml.python.PickleUtil;
import org.jpmml.python.Storage;
import org.jpmml.python.StorageUtil;
import org.jpmml.sklearn.Encodable;
import org.jpmml.sklearn.EncodableUtil;
import org.jpmml.sklearn.SkLearnUtil;
import org.jpmml.telemetry.Incident;
import org.jpmml.telemetry.TelemetryClient;

public class Main
extends Application {
    @Parameter(names={"--pkl-pipeline-input", "--pkl-input"}, required=true, order=1)
    private File inputFile = null;
    @Parameter(names={"--pmml-output"}, required=true, order=2)
    private File outputFile = null;
    @Parameter(names={"--pmml-schema", "--schema"}, converter=VersionConverter.class, order=3)
    private Version version = null;
    private static final Logger logger;

    public static void main(String ... args) throws Exception {
        Main main = new Main();
        JCommander commander = JCommander.newBuilder().addObject((Object)main).build();
        commander.parse(args);
        main.validate();
        try {
            Application.setInstance((Application)main);
            main.run();
        }
        catch (Exception e) {
            Package _package = Main.class.getPackage();
            LinkedHashMap<String, String> environment = new LinkedHashMap<String, String>();
            environment.put("sklearn2pmml", _package.getImplementationVersion());
            Incident incident = new Incident().setProject("sklearn2pmml").setEnvironment(environment).setException(e);
            try {
                TelemetryClient.report((String)"https://telemetry.jpmml.org/v1/incidents", (Incident)incident);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw e;
        }
        finally {
            Application.setInstance(null);
        }
    }

    private void validate() {
        Instant buildTimestamp = this.getBuildTimestamp();
        if (buildTimestamp != null) {
            Instant now = Instant.now();
            Instant updateRequiredTimestamp = now.minus(360L, ChronoUnit.DAYS);
            if (buildTimestamp.isBefore(updateRequiredTimestamp)) {
                logger.severe("The SkLearn2PMML package is older than 12 months and must be updated");
                throw new RuntimeException("The SkLearn2PMML package has expired");
            }
            Instant updateRecommendedTimestamp = now.minus(180L, ChronoUnit.DAYS);
            if (buildTimestamp.isBefore(updateRecommendedTimestamp)) {
                logger.warning("The SkLearn2PMML package is older than 6 months and should be updated");
            }
        }
    }

    private void run() throws Exception {
        File absoluteOutputFile;
        File outputDir;
        Object object;
        try (Storage storage = StorageUtil.createStorage((File)this.inputFile);){
            object = PickleUtil.unpickle((Storage)storage);
        }
        Encodable encodable = EncodableUtil.toEncodable((Object)object);
        PMML pmml = encodable.encodePMML();
        if (!this.outputFile.exists() && !(outputDir = (absoluteOutputFile = this.outputFile.getAbsoluteFile()).getParentFile()).exists()) {
            outputDir.mkdirs();
        }
        if (this.version != null && this.version.compareTo((Enum)Version.XPMML) < 0) {
            VersionStandardizer versionStandardizer = new VersionStandardizer();
            versionStandardizer.applyTo((Visitable)pmml);
            VersionDowngrader versionDowngrader = new VersionDowngrader(this.version);
            versionDowngrader.applyTo((Visitable)pmml);
            VersionChecker versionChecker = new VersionChecker(this.version);
            versionChecker.applyTo((Visitable)pmml);
            List exceptions = versionChecker.getExceptions();
            if (!exceptions.isEmpty()) {
                logger.severe("The PMML object has " + exceptions.size() + " incompatibilities with the requested PMML schema version:");
                LinkedHashMultiset groupedMessages = LinkedHashMultiset.create();
                for (MarkupException exception : exceptions) {
                    groupedMessages.add((Object)exception.getMessage());
                }
                Set entries = groupedMessages.entrySet();
                for (Multiset.Entry entry : entries) {
                    logger.warning((String)entry.getElement() + (String)(entry.getCount() > 1 ? " (" + entry.getCount() + " cases)" : ""));
                }
            }
            MetroJAXBSerializer jaxbSerializer = new MetroJAXBSerializer();
            try (PMMLOutputStream os = new PMMLOutputStream((OutputStream)new FileOutputStream(this.outputFile), this.version);){
                jaxbSerializer.serializePretty((PMMLObject)pmml, (OutputStream)os);
            }
        }
        MetroJAXBSerializer jaxbSerializer = new MetroJAXBSerializer();
        try (FileOutputStream os = new FileOutputStream(this.outputFile);){
            jaxbSerializer.serializePretty((PMMLObject)pmml, (OutputStream)os);
        }
    }

    private Instant getBuildTimestamp() {
        Manifest manifest = this.getManifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        String buildTimestampString = mainAttributes.getValue("Build-Timestamp");
        if (buildTimestampString == null) {
            throw new RuntimeException("The SkLearn2PMML package is not dated");
        }
        return Instant.parse(buildTimestampString);
    }

    static {
        LogManager logManager = LogManager.getLogManager();
        try {
            logManager.readConfiguration(Main.class.getResourceAsStream("/logging.properties"));
        }
        catch (IOException ioe) {
            ioe.printStackTrace(System.err);
        }
        logger = Logger.getLogger(Main.class);
        SkLearnUtil.initOnce();
    }
}

