/*
 * Decompiled with CFR 0.152.
 */
package sklearn2pmml.preprocessing;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.dmg.pmml.Apply;
import org.dmg.pmml.DataType;
import org.dmg.pmml.DerivedField;
import org.dmg.pmml.Expression;
import org.dmg.pmml.Extension;
import org.dmg.pmml.Field;
import org.dmg.pmml.OpType;
import org.jpmml.converter.ExpressionUtil;
import org.jpmml.converter.Feature;
import org.jpmml.converter.PMMLEncoder;
import org.jpmml.converter.StringFeature;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.RegExFlavour;
import org.jpmml.sklearn.SkLearnEncoder;
import sklearn2pmml.preprocessing.RegExTransformer;

public class ReplaceTransformer
extends RegExTransformer {
    public ReplaceTransformer() {
        this("sklearn2pmml.preprocessing", "ReplaceTransformer");
    }

    public ReplaceTransformer(String module, String name) {
        super(module, name);
    }

    @Override
    public List<Feature> encodeFeatures(List<Feature> features, SkLearnEncoder encoder) {
        String pattern = this.getPattern();
        String replacement = this.getReplacement();
        RegExFlavour reFlavour = ReplaceTransformer.parseReFlavour(this.getReFlavour());
        if (reFlavour != null) {
            pattern = reFlavour.translatePattern(pattern);
            replacement = reFlavour.translateReplacement(replacement);
        }
        ClassDictUtil.checkSize((int)1, (Collection[])new Collection[]{features});
        Feature feature = features.get(0);
        if (feature.getDataType() != DataType.STRING) {
            throw new IllegalArgumentException();
        }
        Apply apply = ExpressionUtil.createApply((String)"replace", (Expression[])new Expression[]{feature.ref(), ExpressionUtil.createConstant((DataType)DataType.STRING, (Object)pattern), ExpressionUtil.createConstant((DataType)DataType.STRING, (Object)replacement)});
        if (reFlavour != null) {
            apply.addExtensions(new Extension[]{reFlavour.createExtension()});
        }
        DerivedField derivedField = encoder.createDerivedField(this.createFieldName("replace", feature, ReplaceTransformer.formatArg(pattern), ReplaceTransformer.formatArg(replacement)), OpType.CATEGORICAL, DataType.STRING, (Expression)apply);
        return Collections.singletonList(new StringFeature((PMMLEncoder)encoder, (Field)derivedField));
    }

    @Override
    ReplaceTransformer setPattern(String pattern) {
        return (ReplaceTransformer)super.setPattern(pattern);
    }

    @Override
    ReplaceTransformer setReFlavour(String reFlavour) {
        return (ReplaceTransformer)super.setReFlavour(reFlavour);
    }

    public String getReplacement() {
        return this.getString("replacement");
    }

    ReplaceTransformer setReplacement(String replacement) {
        this.setattr("replacement", replacement);
        return this;
    }
}

