/*
 * Decompiled with CFR 0.152.
 */
package org.jpmml.python;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import functools.Partial;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import joblib.NDArrayWrapper;
import net.razorvine.pickle.objects.ClassDict;
import numpy.core.NDArray;
import numpy.core.NDArrayUtil;
import numpy.core.Scalar;
import numpy.core.ScalarUtil;
import org.jpmml.converter.ValueUtil;
import org.jpmml.model.ReflectionUtil;
import org.jpmml.python.AttributeCastFunction;
import org.jpmml.python.AttributeException;
import org.jpmml.python.ClassDictUtil;
import org.jpmml.python.HasArray;
import org.jpmml.python.Identifiable;
import org.jpmml.python.PythonFormatterUtil;
import org.jpmml.python.PythonObjectConstructor;

public abstract class PythonObject
extends ClassDict {
    private static final Field FIELD_CLASSNAME = ReflectionUtil.getField(ClassDict.class, (String)"classname");

    public PythonObject(String module, String name) {
        super(module, name);
    }

    public String getPythonModule() {
        String className = this.getClassName();
        int dot = className.lastIndexOf(46);
        if (dot > -1) {
            return className.substring(0, dot);
        }
        return null;
    }

    public String getPythonName() {
        String className = this.getClassName();
        int dot = className.lastIndexOf(46);
        if (dot > -1) {
            return className.substring(dot + 1);
        }
        return className;
    }

    public String getClassName() {
        return super.getClassName();
    }

    public PythonObject setClassName(String className) {
        ReflectionUtil.setFieldValue((Field)FIELD_CLASSNAME, (Object)((Object)this), (Object)className);
        this.setattr("__class__", className);
        return this;
    }

    public boolean containsKey(Object key) {
        return super.containsKey(key);
    }

    public Object get(Object key) {
        return super.get(key);
    }

    public Object put(String key, Object value) {
        return super.put((Object)key, value);
    }

    public void putAll(Map<? extends String, ?> map) {
        super.putAll(map);
    }

    public Object remove(Object key) {
        return super.remove(key);
    }

    public boolean hasattr(String name) {
        return this.containsKey(name);
    }

    public Object getattr(String name) {
        if (!this.containsKey(name)) {
            throw new AttributeException("Attribute '" + ClassDictUtil.formatMember(this, name) + "' not set");
        }
        return this.get(name);
    }

    public Object getattr(String name, Object defaultValue) {
        if (!this.containsKey(name)) {
            return defaultValue;
        }
        return this.get(name);
    }

    public void setattr(String name, Object value) {
        this.put(name, value);
    }

    public void update(Map<String, ?> dict) {
        this.putAll(dict);
    }

    public void delattr(String name) {
        this.remove(name);
    }

    public <E> E get(final String name, Class<? extends E> clazz) {
        Object value = this.getattr(name);
        if (value == null) {
            throw new AttributeException("Attribute '" + ClassDictUtil.formatMember(this, name) + "' has a missing (None) value");
        }
        if (Objects.equals(Boolean.class, clazz) || Number.class.isAssignableFrom(clazz) || Objects.equals(String.class, clazz)) {
            if (value instanceof Scalar) {
                Scalar scalar = (Scalar)value;
                value = scalar.getOnlyElement();
            }
        } else if (Objects.equals(Identifiable.class, clazz)) {
            if (value instanceof Partial) {
                Partial partial = (Partial)((Object)value);
                value = partial.toIdentifiable();
            } else if (value instanceof PythonObjectConstructor) {
                PythonObjectConstructor dictConstructor = (PythonObjectConstructor)((Object)value);
                value = dictConstructor.newObject();
            }
        }
        AttributeCastFunction castFunction = new AttributeCastFunction<E>(clazz){

            @Override
            protected String formatMessage(Object object) {
                return "Attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' has an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return castFunction.apply(value);
    }

    public <E> E getOptional(String name, Class<? extends E> clazz) {
        Object value = this.getattr(name, null);
        if (value == null) {
            return null;
        }
        return this.get(name, clazz);
    }

    public Object getObject(String name) {
        return this.get(name, Object.class);
    }

    public Object getOptionalObject(String name) {
        return this.getOptional(name, Object.class);
    }

    public Object getScalar(String name) {
        Object object = this.getObject(name);
        return ScalarUtil.decode(object);
    }

    public Object getOptionalScalar(String name) {
        Object object = this.getOptionalObject(name);
        return ScalarUtil.decode(object);
    }

    public Boolean getBoolean(String name) {
        return this.get(name, Boolean.class);
    }

    public Boolean getOptionalBoolean(String name) {
        return this.getOptional(name, Boolean.class);
    }

    public Boolean getOptionalBoolean(String name, Boolean defaultValue) {
        Boolean value = this.getOptionalBoolean(name);
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public Number getNumber(String name) {
        return this.get(name, Number.class);
    }

    public Number getOptionalNumber(String name) {
        return this.getOptional(name, Number.class);
    }

    public Integer getInteger(String name) {
        Number value = this.getNumber(name);
        return ValueUtil.asInteger((Number)value);
    }

    public Integer getOptionalInteger(String name) {
        Number value = this.getOptionalNumber(name);
        if (value == null) {
            return null;
        }
        return ValueUtil.asInteger((Number)value);
    }

    public String getString(String name) {
        return this.get(name, String.class);
    }

    public String getOptionalString(String name) {
        return this.getOptional(name, String.class);
    }

    public Identifiable getIdentifiable(String name) {
        return this.get(name, Identifiable.class);
    }

    public Identifiable getOptionalIdentifiable(String name) {
        return this.getOptional(name, Identifiable.class);
    }

    public <E> E getEnum(String name, Function<String, E> function, Collection<E> enumValues) {
        Object value = function.apply((Object)name);
        if (!enumValues.contains(value)) {
            throw new AttributeException("Attribute '" + ClassDictUtil.formatMember(this, name) + "' has an unsupported value " + PythonFormatterUtil.formatValue(value) + ". Supported values are " + PythonFormatterUtil.formatCollection(enumValues));
        }
        return (E)value;
    }

    public <E> E getOptionalEnum(String name, Function<String, E> function, Collection<E> enumValues) {
        Object value = function.apply((Object)name);
        if (value != null && !enumValues.contains(value)) {
            throw new AttributeException("Attribute '" + ClassDictUtil.formatMember(this, name) + "' has an unsupported value " + PythonFormatterUtil.formatValue(value) + ". Supported values are " + PythonFormatterUtil.formatCollection(enumValues));
        }
        return (E)value;
    }

    public Object[] getTuple(String name) {
        return this.get(name, Object[].class);
    }

    public Object[] getOptionalTuple(String name) {
        return this.getOptional(name, Object[].class);
    }

    public Map<String, ?> getDict(String name) {
        return this.get(name, Map.class);
    }

    public Map<String, ?> getOptionalDict(String name) {
        return this.getOptional(name, Map.class);
    }

    public HasArray getArray(String name) {
        Object object = this.getObject(name);
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray;
        }
        throw new AttributeException("Array attribute '" + ClassDictUtil.formatMember(this, name) + "' has an unsupported value (" + ClassDictUtil.formatClass(object) + ")");
    }

    public <E> List<E> getArray(final String name, Class<? extends E> clazz) {
        HasArray hasArray = this.getArray(name);
        List<?> values = hasArray.getArrayContent();
        AttributeCastFunction castFunction = new AttributeCastFunction<E>(clazz){

            @Override
            protected String formatMessage(Object object) {
                return "Array attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return Lists.transform(values, (Function)castFunction);
    }

    public int[] getArrayShape(String name) {
        Object object = this.getObject(name);
        if (object instanceof HasArray) {
            HasArray hasArray = (HasArray)object;
            return hasArray.getArrayShape();
        }
        if (object instanceof Number) {
            return new int[]{1};
        }
        throw new AttributeException("Array attribute '" + ClassDictUtil.formatMember(this, name) + "' has an unsuppoted value (" + ClassDictUtil.formatClass(object) + ")");
    }

    public int[] getArrayShape(String name, int length) {
        int[] shape = this.getArrayShape(name);
        if (shape.length != length) {
            throw new AttributeException("Array attribute '" + ClassDictUtil.formatMember(this, name) + "' is mis-shaped");
        }
        return shape;
    }

    public List<Object> getObjectArray(String name) {
        return this.getArray(name, Object.class);
    }

    public List<Boolean> getBooleanArray(String name) {
        return this.getArray(name, Boolean.class);
    }

    public List<Number> getNumberArray(final String name) {
        Object object = this.getObject(name);
        if (Number.class.isInstance(object)) {
            return Collections.singletonList((Number)object);
        }
        HasArray hasArray = this.getArray(name);
        List<?> values = hasArray.getArrayContent();
        AttributeCastFunction<Number> castFunction = new AttributeCastFunction<Number>(Number.class){

            @Override
            public Number apply(Object object) {
                return (Number)super.apply(ScalarUtil.decode(object));
            }

            @Override
            protected String formatMessage(Object object) {
                return "Array attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return Lists.transform(values, (Function)castFunction);
    }

    public List<Integer> getIntegerArray(String name) {
        List<Number> values = this.getNumberArray(name);
        return ValueUtil.asIntegers(values);
    }

    public List<String> getStringArray(String name) {
        return this.getArray(name, String.class);
    }

    public List<?> getArray(String name, String key) {
        Object object = this.getObject(name);
        if (object instanceof NDArrayWrapper) {
            NDArrayWrapper arrayWrapper = (NDArrayWrapper)object;
            object = arrayWrapper.getContent();
        }
        if (object instanceof NDArray) {
            NDArray array = (NDArray)object;
            return NDArrayUtil.getContent(array, key);
        }
        throw new AttributeException("Array attribute '" + ClassDictUtil.formatMember(this, name) + "' has an unsupported value (" + ClassDictUtil.formatClass(object) + ")");
    }

    public List<?> getList(String name) {
        return this.get(name, List.class);
    }

    public <E> List<E> getList(final String name, Class<? extends E> clazz) {
        List<?> values = this.getList(name);
        AttributeCastFunction castFunction = new AttributeCastFunction<E>(clazz){

            @Override
            protected String formatMessage(Object object) {
                return "List attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return Lists.transform(values, (Function)castFunction);
    }

    public List<Object> getObjectList(String name) {
        return this.getList(name, Object.class);
    }

    public List<String> getStringList(String name) {
        return this.getList(name, String.class);
    }

    public <E> List<E> getEnumList(final String name, Function<String, List<E>> function, final Collection<E> enumValues) {
        List values = (List)function.apply((Object)name);
        Function enumFunction = new Function<E, E>(){

            public E apply(E value) {
                if (!enumValues.contains(value)) {
                    throw new AttributeException("List attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value " + PythonFormatterUtil.formatValue(value) + ". Supported values are " + PythonFormatterUtil.formatCollection(enumValues));
                }
                return value;
            }
        };
        return Lists.transform((List)values, (Function)enumFunction);
    }

    public List<Object[]> getTupleList(String name) {
        return this.getList(name, Object[].class);
    }

    public List<HasArray> getArrayList(String name) {
        return this.getList(name, HasArray.class);
    }

    public <E> List<List<E>> getArrayList(final String name, Class<? extends E> clazz) {
        List<HasArray> values = this.getArrayList(name);
        final AttributeCastFunction castFunction = new AttributeCastFunction<E>(clazz){

            @Override
            protected String formatMessage(Object object) {
                return "List of arrays attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        Function function = new Function<HasArray, List<E>>(){

            public List<E> apply(HasArray hasArray) {
                if (hasArray == null) {
                    return null;
                }
                List<?> values = hasArray.getArrayContent();
                return Lists.transform(values, (Function)castFunction);
            }
        };
        return Lists.transform(values, (Function)function);
    }

    public List<?> getListLike(String name) {
        Object object = this.getObject(name);
        if (object instanceof HasArray) {
            HasArray hasArray = this.getArray(name);
            return hasArray.getArrayContent();
        }
        return this.getList(name);
    }

    public <E> List<E> getListLike(final String name, Class<? extends E> clazz) {
        Object object = this.getObject(name);
        if (Objects.equals(Object.class, clazz)) {
            throw new IllegalArgumentException();
        }
        if (clazz.isInstance(object)) {
            return Collections.singletonList(clazz.cast(object));
        }
        List<?> values = this.getListLike(name);
        AttributeCastFunction castFunction = new AttributeCastFunction<E>(clazz){

            @Override
            protected String formatMessage(Object object) {
                return "Array or list attribute '" + ClassDictUtil.formatMember(PythonObject.this, name) + "' contains an unsupported value (" + ClassDictUtil.formatClass(object) + ")";
            }
        };
        return Lists.transform(values, (Function)castFunction);
    }
}

