"use strict";
var _a, _b, _c;
Object.defineProperty(exports, "__esModule", { value: true });
exports.CfnReplicaKey = exports.CfnKey = exports.CfnAlias = void 0;
const jsiiDeprecationWarnings = require("../.warnings.jsii.js");
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright 2012-2023 Amazon.com, Inc. or its affiliates. All Rights Reserved.
// Generated from the AWS CloudFormation Resource Specification
// See: docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/cfn-resource-specification.html
// @cfn2ts:meta@ {"generated":"2023-04-20T16:24:54.861Z","fingerprint":"MWHydVeGU4cko4q/pMxsrNS1J9WTohANh0il4gNtK2g="}
/* eslint-disable max-len */ // This is generated code - line lengths are difficult to control
const cdk = require("@aws-cdk/core");
const cfn_parse = require("@aws-cdk/core/lib/helpers-internal");
/**
 * Determine whether the given properties match those of a `CfnAliasProps`
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the result of the validation.
 */
function CfnAliasPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('aliasName', cdk.requiredValidator)(properties.aliasName));
    errors.collect(cdk.propertyValidator('aliasName', cdk.validateString)(properties.aliasName));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.requiredValidator)(properties.targetKeyId));
    errors.collect(cdk.propertyValidator('targetKeyId', cdk.validateString)(properties.targetKeyId));
    return errors.wrap('supplied properties not correct for "CfnAliasProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Alias` resource
 *
 * @param properties - the TypeScript properties of a `CfnAliasProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Alias` resource.
 */
// @ts-ignore TS6133
function cfnAliasPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnAliasPropsValidator(properties).assertSuccess();
    return {
        AliasName: cdk.stringToCloudFormation(properties.aliasName),
        TargetKeyId: cdk.stringToCloudFormation(properties.targetKeyId),
    };
}
// @ts-ignore TS6133
function CfnAliasPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('aliasName', 'AliasName', cfn_parse.FromCloudFormation.getString(properties.AliasName));
    ret.addPropertyResult('targetKeyId', 'TargetKeyId', cfn_parse.FromCloudFormation.getString(properties.TargetKeyId));
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Alias`
 *
 * The `AWS::KMS::Alias` resource specifies a display name for a [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) . You can use an alias to identify a KMS key in the AWS KMS console, in the [DescribeKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_DescribeKey.html) operation, and in [cryptographic operations](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#cryptographic-operations) , such as [Decrypt](https://docs.aws.amazon.com/kms/latest/APIReference/API_Decrypt.html) and [GenerateDataKey](https://docs.aws.amazon.com/kms/latest/APIReference/API_GenerateDataKey.html) .
 *
 * > Adding, deleting, or updating an alias can allow or deny permission to the KMS key. For details, see [ABAC for AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/abac.html) in the *AWS Key Management Service Developer Guide* .
 *
 * Using an alias to refer to a KMS key can help you simplify key management. For example, an alias in your code can be associated with different KMS keys in different AWS Regions . For more information, see [Using aliases](https://docs.aws.amazon.com/kms/latest/developerguide/kms-alias.html) in the *AWS Key Management Service Developer Guide* .
 *
 * When specifying an alias, observe the following rules.
 *
 * - Each alias is associated with one KMS key, but multiple aliases can be associated with the same KMS key.
 * - The alias and its associated KMS key must be in the same AWS account and Region.
 * - The alias name must be unique in the AWS account and Region. However, you can create aliases with the same name in different AWS Regions . For example, you can have an `alias/projectKey` in multiple Regions, each of which is associated with a KMS key in its Region.
 * - Each alias name must begin with `alias/` followed by a name, such as `alias/exampleKey` . The alias name can contain only alphanumeric characters, forward slashes (/), underscores (_), and dashes (-). Alias names cannot begin with `alias/aws/` . That alias name prefix is reserved for [AWS managed keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#aws-managed-cmk) .
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are available in all AWS Regions in which AWS KMS and AWS CloudFormation are supported.
 *
 * @cloudformationResource AWS::KMS::Alias
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-alias.html
 */
class CfnAlias extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::Alias`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnAlias.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnAliasProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnAlias);
            }
            throw error;
        }
        cdk.requireProperty(props, 'aliasName', this);
        cdk.requireProperty(props, 'targetKeyId', this);
        this.aliasName = props.aliasName;
        this.targetKeyId = props.targetKeyId;
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnAliasPropsFromCloudFormation(resourceProperties);
        const ret = new CfnAlias(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnAlias.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            aliasName: this.aliasName,
            targetKeyId: this.targetKeyId,
        };
    }
    renderProperties(props) {
        return cfnAliasPropsToCloudFormation(props);
    }
}
exports.CfnAlias = CfnAlias;
_a = JSII_RTTI_SYMBOL_1;
CfnAlias[_a] = { fqn: "@aws-cdk/aws-kms.CfnAlias", version: "1.199.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnAlias.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Alias";
/**
 * Determine whether the given properties match those of a `CfnKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enableKeyRotation', cdk.validateBoolean)(properties.enableKeyRotation));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keySpec', cdk.validateString)(properties.keySpec));
    errors.collect(cdk.propertyValidator('keyUsage', cdk.validateString)(properties.keyUsage));
    errors.collect(cdk.propertyValidator('multiRegion', cdk.validateBoolean)(properties.multiRegion));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::Key` resource
 *
 * @param properties - the TypeScript properties of a `CfnKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::Key` resource.
 */
// @ts-ignore TS6133
function cfnKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        EnableKeyRotation: cdk.booleanToCloudFormation(properties.enableKeyRotation),
        KeySpec: cdk.stringToCloudFormation(properties.keySpec),
        KeyUsage: cdk.stringToCloudFormation(properties.keyUsage),
        MultiRegion: cdk.booleanToCloudFormation(properties.multiRegion),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('enableKeyRotation', 'EnableKeyRotation', properties.EnableKeyRotation != null ? cfn_parse.FromCloudFormation.getBoolean(properties.EnableKeyRotation) : undefined);
    ret.addPropertyResult('keySpec', 'KeySpec', properties.KeySpec != null ? cfn_parse.FromCloudFormation.getString(properties.KeySpec) : undefined);
    ret.addPropertyResult('keyUsage', 'KeyUsage', properties.KeyUsage != null ? cfn_parse.FromCloudFormation.getString(properties.KeyUsage) : undefined);
    ret.addPropertyResult('multiRegion', 'MultiRegion', properties.MultiRegion != null ? cfn_parse.FromCloudFormation.getBoolean(properties.MultiRegion) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::Key`
 *
 * The `AWS::KMS::Key` resource specifies an [KMS key](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#kms_keys) in AWS Key Management Service . You can use this resource to create symmetric encryption KMS keys, asymmetric KMS keys for encryption or signing, and symmetric HMAC KMS keys. You can use `AWS::KMS::Key` to create [multi-Region primary keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html#mrk-primary-key) of all supported types. To replicate a multi-Region key, use the `AWS::KMS::ReplicaKey` resource.
 *
 * > If you change the value of the `KeySpec` , `KeyUsage` , or `MultiRegion` properties of an existing KMS key, the update request fails, regardless of the value of the [`UpdateReplacePolicy` attribute](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-attribute-updatereplacepolicy.html) . This prevents you from accidentally deleting a KMS key by changing any of its immutable property values. > AWS KMS replaced the term *customer master key (CMK)* with *AWS KMS key* and *KMS key* . The concept has not changed. To prevent breaking changes, AWS KMS is keeping some variations of this term.
 *
 * You can use symmetric encryption KMS keys to encrypt and decrypt small amounts of data, but they are more commonly used to generate data keys and data key pairs. You can also use a symmetric encryption KMS key to encrypt data stored in AWS services that are [integrated with AWS KMS](https://docs.aws.amazon.com//kms/features/#AWS_Service_Integration) . For more information, see [Symmetric encryption KMS keys](https://docs.aws.amazon.com/kms/latest/developerguide/concepts.html#symmetric-cmks) in the *AWS Key Management Service Developer Guide* .
 *
 * You can use asymmetric KMS keys to encrypt and decrypt data or sign messages and verify signatures. To create an asymmetric key, you must specify an asymmetric `KeySpec` value and a `KeyUsage` value. For details, see [Asymmetric keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You can use HMAC KMS keys (which are also symmetric keys) to generate and verify hash-based message authentication codes. To create an HMAC key, you must specify an HMAC `KeySpec` value and a `KeyUsage` value of `GENERATE_VERIFY_MAC` . For details, see [HMAC keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/hmac.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You can also create symmetric encryption, asymmetric, and HMAC multi-Region primary keys. To create a multi-Region primary key, set the `MultiRegion` property to `true` . For information about multi-Region keys, see [Multi-Region keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * You cannot use the `AWS::KMS::Key` resource to specify a KMS key with [imported key material](https://docs.aws.amazon.com/kms/latest/developerguide/importing-keys.html) or a KMS key in a [custom key store](https://docs.aws.amazon.com/kms/latest/developerguide/custom-key-store-overview.html) .
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are available in all Regions in which AWS KMS and AWS CloudFormation are supported. You can use the `AWS::KMS::Key` resource to create and manage all KMS key types that are supported in a Region.
 *
 * @cloudformationResource AWS::KMS::Key
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html
 */
class CfnKey extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::Key`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnKey);
            }
            throw error;
        }
        cdk.requireProperty(props, 'keyPolicy', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId'));
        this.keyPolicy = props.keyPolicy;
        this.description = props.description;
        this.enabled = props.enabled;
        this.enableKeyRotation = props.enableKeyRotation;
        this.keySpec = props.keySpec;
        this.keyUsage = props.keyUsage;
        this.multiRegion = props.multiRegion;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::Key", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            description: this.description,
            enabled: this.enabled,
            enableKeyRotation: this.enableKeyRotation,
            keySpec: this.keySpec,
            keyUsage: this.keyUsage,
            multiRegion: this.multiRegion,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnKeyPropsToCloudFormation(props);
    }
}
exports.CfnKey = CfnKey;
_b = JSII_RTTI_SYMBOL_1;
CfnKey[_b] = { fqn: "@aws-cdk/aws-kms.CfnKey", version: "1.199.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::Key";
/**
 * Determine whether the given properties match those of a `CfnReplicaKeyProps`
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the result of the validation.
 */
function CfnReplicaKeyPropsValidator(properties) {
    if (!cdk.canInspect(properties)) {
        return cdk.VALIDATION_SUCCESS;
    }
    const errors = new cdk.ValidationResults();
    if (typeof properties !== 'object') {
        errors.collect(new cdk.ValidationResult('Expected an object, but received: ' + JSON.stringify(properties)));
    }
    errors.collect(cdk.propertyValidator('description', cdk.validateString)(properties.description));
    errors.collect(cdk.propertyValidator('enabled', cdk.validateBoolean)(properties.enabled));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.requiredValidator)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('keyPolicy', cdk.validateObject)(properties.keyPolicy));
    errors.collect(cdk.propertyValidator('pendingWindowInDays', cdk.validateNumber)(properties.pendingWindowInDays));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.requiredValidator)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('primaryKeyArn', cdk.validateString)(properties.primaryKeyArn));
    errors.collect(cdk.propertyValidator('tags', cdk.listValidator(cdk.validateCfnTag))(properties.tags));
    return errors.wrap('supplied properties not correct for "CfnReplicaKeyProps"');
}
/**
 * Renders the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource
 *
 * @param properties - the TypeScript properties of a `CfnReplicaKeyProps`
 *
 * @returns the AWS CloudFormation properties of an `AWS::KMS::ReplicaKey` resource.
 */
// @ts-ignore TS6133
function cfnReplicaKeyPropsToCloudFormation(properties) {
    if (!cdk.canInspect(properties)) {
        return properties;
    }
    CfnReplicaKeyPropsValidator(properties).assertSuccess();
    return {
        KeyPolicy: cdk.objectToCloudFormation(properties.keyPolicy),
        PrimaryKeyArn: cdk.stringToCloudFormation(properties.primaryKeyArn),
        Description: cdk.stringToCloudFormation(properties.description),
        Enabled: cdk.booleanToCloudFormation(properties.enabled),
        PendingWindowInDays: cdk.numberToCloudFormation(properties.pendingWindowInDays),
        Tags: cdk.listMapper(cdk.cfnTagToCloudFormation)(properties.tags),
    };
}
// @ts-ignore TS6133
function CfnReplicaKeyPropsFromCloudFormation(properties) {
    properties = properties == null ? {} : properties;
    if (typeof properties !== 'object') {
        return new cfn_parse.FromCloudFormationResult(properties);
    }
    const ret = new cfn_parse.FromCloudFormationPropertyObject();
    ret.addPropertyResult('keyPolicy', 'KeyPolicy', cfn_parse.FromCloudFormation.getAny(properties.KeyPolicy));
    ret.addPropertyResult('primaryKeyArn', 'PrimaryKeyArn', cfn_parse.FromCloudFormation.getString(properties.PrimaryKeyArn));
    ret.addPropertyResult('description', 'Description', properties.Description != null ? cfn_parse.FromCloudFormation.getString(properties.Description) : undefined);
    ret.addPropertyResult('enabled', 'Enabled', properties.Enabled != null ? cfn_parse.FromCloudFormation.getBoolean(properties.Enabled) : undefined);
    ret.addPropertyResult('pendingWindowInDays', 'PendingWindowInDays', properties.PendingWindowInDays != null ? cfn_parse.FromCloudFormation.getNumber(properties.PendingWindowInDays) : undefined);
    ret.addPropertyResult('tags', 'Tags', properties.Tags != null ? cfn_parse.FromCloudFormation.getArray(cfn_parse.FromCloudFormation.getCfnTag)(properties.Tags) : undefined);
    ret.addUnrecognizedPropertiesAsExtra(properties);
    return ret;
}
/**
 * A CloudFormation `AWS::KMS::ReplicaKey`
 *
 * The `AWS::KMS::ReplicaKey` resource specifies a multi-Region replica key that is based on a multi-Region primary key.
 *
 * *Multi-Region keys* are an AWS KMS feature that lets you create multiple interoperable KMS keys in different AWS Regions . Because these KMS keys have the same key ID, key material, and other metadata, you can use them to encrypt data in one AWS Region and decrypt it in a different AWS Region without making a cross-Region call or exposing the plaintext data. For more information, see [Multi-Region keys](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the *AWS Key Management Service Developer Guide* .
 *
 * A multi-Region *primary key* is a fully functional symmetric encryption KMS key, HMAC KMS key, or asymmetric KMS key that is also the model for replica keys in other AWS Regions . To create a multi-Region primary key, add an [AWS::KMS::Key](https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-key.html) resource to your CloudFormation stack. Set its `MultiRegion` property to true.
 *
 * A multi-Region *replica key* is a fully functional KMS key that has the same key ID and key material as a multi-Region primary key, but is located in a different AWS Region of the same AWS partition. There can be multiple replicas of a primary key, but each must be in a different AWS Region .
 *
 * When you create a replica key in AWS CloudFormation , the replica key is created in the AWS Region represented by the endpoint you use for the request. If you try to replicate a multi-Region key into a Region in which the key type is not supported, the request will fail.
 *
 * A primary key and its replicas have the same key ID and key material. They also have the same key spec, key usage, key material origin, and automatic key rotation status. These properties are known as *shared properties* . If they change, AWS KMS synchronizes the change to all related multi-Region keys. All other properties of a replica key can differ, including its key policy, tags, aliases, and key state. AWS KMS does not synchronize these properties.
 *
 * *Regions*
 *
 * AWS KMS CloudFormation resources are available in all AWS Regions in which AWS KMS and AWS CloudFormation are supported. You can use the `AWS::KMS::ReplicaKey` resource to create replica keys in all Regions that support multi-Region KMS keys. For details, see [Multi-Region keys in AWS KMS](https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html) in the ** .
 *
 * @cloudformationResource AWS::KMS::ReplicaKey
 * @stability external
 *
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-kms-replicakey.html
 */
class CfnReplicaKey extends cdk.CfnResource {
    /**
     * Create a new `AWS::KMS::ReplicaKey`.
     *
     * @param scope - scope in which this resource is defined
     * @param id    - scoped id of the resource
     * @param props - resource properties
     */
    constructor(scope, id, props) {
        super(scope, id, { type: CfnReplicaKey.CFN_RESOURCE_TYPE_NAME, properties: props });
        try {
            jsiiDeprecationWarnings._aws_cdk_aws_kms_CfnReplicaKeyProps(props);
        }
        catch (error) {
            if (process.env.JSII_DEBUG !== "1" && error.name === "DeprecationError") {
                Error.captureStackTrace(error, CfnReplicaKey);
            }
            throw error;
        }
        cdk.requireProperty(props, 'keyPolicy', this);
        cdk.requireProperty(props, 'primaryKeyArn', this);
        this.attrArn = cdk.Token.asString(this.getAtt('Arn'));
        this.attrKeyId = cdk.Token.asString(this.getAtt('KeyId'));
        this.keyPolicy = props.keyPolicy;
        this.primaryKeyArn = props.primaryKeyArn;
        this.description = props.description;
        this.enabled = props.enabled;
        this.pendingWindowInDays = props.pendingWindowInDays;
        this.tags = new cdk.TagManager(cdk.TagType.STANDARD, "AWS::KMS::ReplicaKey", props.tags, { tagPropertyName: 'tags' });
    }
    /**
     * A factory method that creates a new instance of this class from an object
     * containing the CloudFormation properties of this resource.
     * Used in the @aws-cdk/cloudformation-include module.
     *
     * @internal
     */
    static _fromCloudFormation(scope, id, resourceAttributes, options) {
        resourceAttributes = resourceAttributes || {};
        const resourceProperties = options.parser.parseValue(resourceAttributes.Properties);
        const propsResult = CfnReplicaKeyPropsFromCloudFormation(resourceProperties);
        const ret = new CfnReplicaKey(scope, id, propsResult.value);
        for (const [propKey, propVal] of Object.entries(propsResult.extraProperties)) {
            ret.addPropertyOverride(propKey, propVal);
        }
        options.parser.handleAttributes(ret, resourceAttributes, id);
        return ret;
    }
    /**
     * Examines the CloudFormation resource and discloses attributes.
     *
     * @param inspector - tree inspector to collect and process attributes
     *
     */
    inspect(inspector) {
        inspector.addAttribute("aws:cdk:cloudformation:type", CfnReplicaKey.CFN_RESOURCE_TYPE_NAME);
        inspector.addAttribute("aws:cdk:cloudformation:props", this.cfnProperties);
    }
    get cfnProperties() {
        return {
            keyPolicy: this.keyPolicy,
            primaryKeyArn: this.primaryKeyArn,
            description: this.description,
            enabled: this.enabled,
            pendingWindowInDays: this.pendingWindowInDays,
            tags: this.tags.renderTags(),
        };
    }
    renderProperties(props) {
        return cfnReplicaKeyPropsToCloudFormation(props);
    }
}
exports.CfnReplicaKey = CfnReplicaKey;
_c = JSII_RTTI_SYMBOL_1;
CfnReplicaKey[_c] = { fqn: "@aws-cdk/aws-kms.CfnReplicaKey", version: "1.199.0" };
/**
 * The CloudFormation resource type name for this resource class.
 */
CfnReplicaKey.CFN_RESOURCE_TYPE_NAME = "AWS::KMS::ReplicaKey";
//# sourceMappingURL=data:application/json;base64,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