# generated by datamodel-codegen:
#   filename:  api/createEventPublisherJob.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..configuration import elasticSearchConfiguration
from ..system import eventPublisherJob


class CreateEventPublisherJob(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[Optional[str], Field(None, description='Name of the result')]
    publisherType: Annotated[
        Optional[eventPublisherJob.PublisherType],
        Field(None, description='Publisher Type'),
    ]
    runMode: Annotated[
        Optional[eventPublisherJob.RunMode],
        Field(None, description='This schema publisher run modes.'),
    ]
    entities: Annotated[
        Optional[List[str]], Field(['all'], description='List of Entities to Reindex')
    ]
    recreateIndex: Annotated[
        Optional[bool], Field(False, description='This schema publisher run modes.')
    ]
    batchSize: Annotated[
        Optional[int],
        Field(
            100, description='Maximum number of events sent in a batch (Default 100).'
        ),
    ]
    searchIndexMappingLanguage: Annotated[
        Optional[elasticSearchConfiguration.SearchIndexMappingLanguage],
        Field(
            elasticSearchConfiguration.SearchIndexMappingLanguage.EN,
            description='Recreate Indexes with updated Language',
        ),
    ]
    afterCursor: Annotated[
        Optional[str],
        Field(
            None,
            description='Provide After in case of failure to start reindexing after the issue is solved',
        ),
    ]
