# generated by datamodel-codegen:
#   filename:  api/data/createDataContract.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.data import dataContract, table
from ...type import basic, entityReference, entityReferenceList


class CreateDataContractRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[basic.EntityName, Field(description='Name of the data contract.')]
    displayName: Annotated[
        Optional[str], Field(None, description='Display name of the data contract.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the data contract.'),
    ]
    status: Optional[dataContract.ContractStatus] = dataContract.ContractStatus.Draft
    entity: Annotated[
        entityReference.EntityReference,
        Field(
            description='Reference to the data entity (table, topic, etc.) this contract applies to.'
        ),
    ]
    schema_: Annotated[
        Optional[List[table.Column]],
        Field(
            None, alias='schema', description='Schema definition for the data contract.'
        ),
    ]
    semantics: Annotated[
        Optional[List[basic.SemanticsRule]],
        Field(None, description='Semantics rules defined in the data contract.'),
    ]
    qualityExpectations: Annotated[
        Optional[List[entityReference.EntityReference]],
        Field(None, description='Quality expectations defined in the data contract.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this data contract.'),
    ]
    reviewers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None, description='User references of the reviewers for this data contract.'
        ),
    ]
    effectiveFrom: Annotated[
        Optional[basic.DateTime],
        Field(None, description='Date from which this data contract is effective.'),
    ]
    effectiveUntil: Annotated[
        Optional[basic.DateTime],
        Field(None, description='Date until which this data contract is effective.'),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Source URL of the data contract.'),
    ]
