# generated by datamodel-codegen:
#   filename:  api/lineage/esLineageData.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from typing import Any, List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityLineage


class RelationshipRef(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        Optional[basic.Uuid],
        Field(None, description='Unique identifier of this entity instance.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='FullyQualifiedName of the entity.'),
    ]
    fqnHash: Annotated[
        Optional[str], Field(None, description='FullyQualifiedName Hash of the entity.')
    ]
    type: Annotated[Optional[str], Field(None, description='Type of the entity.')]


class EsLineageData(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    fromEntity: Annotated[
        Optional[RelationshipRef], Field(None, description='From Entity.')
    ]
    toEntity: Annotated[
        Optional[RelationshipRef], Field(None, description='To Entity.')
    ]
    pipeline: Annotated[
        Optional[Any],
        Field(
            None, description='Pipeline in case pipeline is present between entities.'
        ),
    ]
    sqlQuery: Annotated[Optional[str], Field(None, description='Sql Query associated.')]
    columns: Annotated[
        Optional[List[entityLineage.ColumnLineage]],
        Field(None, description='Columns associated.'),
    ]
    description: Annotated[Optional[str], Field(None, description='Description.')]
    source: Annotated[Optional[str], Field(None, description='Source of the Lineage.')]
    docId: Annotated[Optional[str], Field(None, description='Doc Id for the Lineage.')]
    docUniqueId: Annotated[
        Optional[str], Field(None, description='Doc Unique Id for the Lineage.')
    ]
    pipelineEntityType: Annotated[
        Optional[str], Field(None, description='Pipeline Entity or Stored procedure.')
    ]
    createdAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    createdBy: Annotated[
        Optional[str], Field(None, description='User who created the node.')
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    assetEdges: Annotated[
        Optional[int],
        Field(None, description='Asset count in case of child assets lineage.'),
    ]
