# generated by datamodel-codegen:
#   filename:  api/search/previewSearchRequest.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...configuration import searchSettings


class SortOrder(Enum):
    asc = 'asc'
    desc = 'desc'


class PreviewSearchRequest(BaseModel):
    query: Annotated[
        str, Field(description='The query text to execute against the search index.')
    ]
    index: Annotated[
        str,
        Field(
            description='The index to run the query against (e.g., table_search_index).'
        ),
    ]
    searchSettings: searchSettings.SearchSettings
    from_: Annotated[
        Optional[int], Field(0, alias='from', description='Pagination start index.')
    ]
    size: Annotated[
        Optional[int], Field(10, description='Number of results to return.')
    ]
    sortField: Optional[str] = '_score'
    sortOrder: Optional[SortOrder] = SortOrder.desc
    trackTotalHits: Optional[bool] = False
    queryFilter: Optional[str] = None
    postFilter: Optional[str] = None
    fetchSource: Optional[bool] = True
    includeSourceFields: Optional[List[str]] = None
    explain: Optional[bool] = False
