# generated by datamodel-codegen:
#   filename:  api/services/createMetadataService.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...entity.services import metadataService
from ...type import basic, entityReference, entityReferenceList, tagLabel


class CreateMetadataServiceRequest(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    name: Annotated[
        basic.EntityName,
        Field(description='Name that identifies the this entity instance uniquely'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this Metadata service.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of Metadata entity.'),
    ]
    serviceType: metadataService.MetadataServiceType
    connection: Optional[metadataService.MetadataConnection] = None
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Metadata service.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags for this Metadata Service.'),
    ]
    domains: Annotated[
        Optional[List[str]],
        Field(
            None,
            description='Fully qualified names of the domains the Metadata Service belongs to.',
        ),
    ]
    ingestionRunner: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='The ingestion agent responsible for executing the ingestion pipeline.',
        ),
    ]
