# generated by datamodel-codegen:
#   filename:  auth/ssoAuth.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ..security.client import (
    auth0SSOClientConfig,
    azureSSOClientConfig,
    customOidcSSOClientConfig,
    googleSSOClientConfig,
    oktaSSOClientConfig,
    samlSSOClientConfig,
)


class SsoServiceType(Enum):
    google = 'google'
    okta = 'okta'
    auth0 = 'auth0'
    custom_oidc = 'custom-oidc'
    azure = 'azure'


class SSOAuthMechanism(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    ssoServiceType: Annotated[
        Optional[SsoServiceType],
        Field(None, description='Type of database service such as Amundsen, Atlas...'),
    ]
    authConfig: Annotated[
        Optional[
            Union[
                googleSSOClientConfig.GoogleSSOClientConfig,
                oktaSSOClientConfig.OktaSSOClientConfig,
                auth0SSOClientConfig.Auth0SSOClientConfig,
                azureSSOClientConfig.AzureSSOClientConfig,
                customOidcSSOClientConfig.CustomOIDCSSOClientConfig,
                samlSSOClientConfig.SamlSSOClientConfig,
            ]
        ],
        Field(None, description='The authentication configuration used by the SSO'),
    ]
