# generated by datamodel-codegen:
#   filename:  entity/data/file.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import driveService


class FileType(Enum):
    Document = 'Document'
    Spreadsheet = 'Spreadsheet'
    Presentation = 'Presentation'
    Image = 'Image'
    Video = 'Video'
    Audio = 'Audio'
    PDF = 'PDF'
    Archive = 'Archive'
    Code = 'Code'
    Data = 'Data'
    CSV = 'CSV'
    Text = 'Text'
    Other = 'Other'


class File(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this file instance.')
    ]
    name: Annotated[basic.EntityName, Field(description='Name of the file.')]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Fully qualified name of the file.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this file.'),
    ]
    description: Annotated[
        Optional[basic.Markdown], Field(None, description='Description of the file.')
    ]
    service: Annotated[
        entityReference.EntityReference, Field(description='Link to the drive service')
    ]
    serviceType: Annotated[
        Optional[driveService.DriveServiceType],
        Field(None, description='Type of drive service'),
    ]
    directory: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='Parent directory containing this file'),
    ]
    fileType: Optional[FileType] = None
    mimeType: Annotated[Optional[str], Field(None, description='MIME type of the file')]
    fileExtension: Annotated[Optional[str], Field(None, description='File extension')]
    path: Annotated[Optional[str], Field(None, description='Full path to the file')]
    size: Annotated[Optional[int], Field(None, description='File size in bytes')]
    checksum: Annotated[Optional[str], Field(None, description='File checksum/hash')]
    webViewLink: Annotated[
        Optional[AnyUrl], Field(None, description='Web link to view the file')
    ]
    downloadLink: Annotated[
        Optional[AnyUrl], Field(None, description='Direct download link')
    ]
    isShared: Annotated[
        Optional[bool], Field(False, description='Whether this file is shared')
    ]
    fileVersion: Annotated[
        Optional[str], Field(None, description='File version information')
    ]
    createdTime: Annotated[
        Optional[basic.Timestamp], Field(None, description='File creation timestamp')
    ]
    modifiedTime: Annotated[
        Optional[basic.Timestamp],
        Field(None, description='Last modification timestamp'),
    ]
    lastModifiedBy: Annotated[
        Optional[entityReference.EntityReference],
        Field(None, description='User who last modified the file'),
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Link to this file in the source system.'),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this file.'),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this file.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this entity.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags associated with this file.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domains the File belongs to.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this file.'),
    ]
