# generated by datamodel-codegen:
#   filename:  entity/data/worksheet.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import (
    assetCertification,
    basic,
    entityHistory,
    entityReference,
    entityReferenceList,
    lifeCycle,
    tagLabel,
    usageDetails,
    votes,
)
from ..services import driveService
from . import table


class Worksheet(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier of this worksheet instance.')
    ]
    name: Annotated[basic.EntityName, Field(description='Name of the worksheet.')]
    fullyQualifiedName: Annotated[
        Optional[basic.FullyQualifiedEntityName],
        Field(None, description='Fully qualified name of the worksheet.'),
    ]
    displayName: Annotated[
        Optional[str],
        Field(None, description='Display Name that identifies this worksheet.'),
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(None, description='Description of the worksheet.'),
    ]
    spreadsheet: Annotated[
        entityReference.EntityReference,
        Field(
            description='Reference to the parent File entity (with fileType=Spreadsheet)'
        ),
    ]
    service: Annotated[
        entityReference.EntityReference, Field(description='Link to the drive service')
    ]
    serviceType: Annotated[
        Optional[driveService.DriveServiceType],
        Field(None, description='Type of drive service'),
    ]
    worksheetId: Annotated[
        Optional[str], Field(None, description='Native worksheet/tab ID')
    ]
    index: Annotated[
        Optional[int],
        Field(None, description='Position/index of the worksheet in the spreadsheet'),
    ]
    rowCount: Annotated[
        Optional[int], Field(None, description='Number of rows in the worksheet')
    ]
    columnCount: Annotated[
        Optional[int], Field(None, description='Number of columns in the worksheet')
    ]
    columns: Annotated[
        Optional[List[table.Column]],
        Field([], description='Column definitions if structured data'),
    ]
    sampleData: Annotated[
        Optional[table.TableData],
        Field(None, description='Sample data from the worksheet'),
    ]
    isHidden: Annotated[
        Optional[bool], Field(False, description='Whether the worksheet is hidden')
    ]
    sourceUrl: Annotated[
        Optional[basic.SourceUrl],
        Field(None, description='Link to this worksheet in the source system.'),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(
            None, description='Link to the resource corresponding to this worksheet.'
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this worksheet.'),
    ]
    followers: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Followers of this entity.'),
    ]
    tags: Annotated[
        Optional[List[tagLabel.TagLabel]],
        Field(None, description='Tags associated with this worksheet.'),
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the entity.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the entity in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Domains the Worksheet belongs to.'),
    ]
    dataProducts: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='List of data products this entity is part of.'),
    ]
    lifeCycle: Annotated[
        Optional[lifeCycle.LifeCycle],
        Field(None, description='Life Cycle of the entity'),
    ]
    sourceHash: Annotated[
        Optional[str],
        Field(
            None, description='Source hash of the entity', max_length=32, min_length=1
        ),
    ]
    extension: Annotated[
        Optional[basic.EntityExtension],
        Field(
            None,
            description='Entity extension data with custom attributes added to the entity.',
        ),
    ]
    votes: Annotated[
        Optional[votes.Votes], Field(None, description='Votes on the entity.')
    ]
    certification: Optional[assetCertification.AssetCertification] = None
    usageSummary: Annotated[
        Optional[usageDetails.UsageDetails],
        Field(None, description='Latest usage information for this worksheet.'),
    ]
