# generated by datamodel-codegen:
#   filename:  entity/policies/accessControl/resourcePermission.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import List, Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from . import resourceDescriptor, rule


class Access(Enum):
    deny = 'deny'
    allow = 'allow'
    conditionalDeny = 'conditionalDeny'
    conditionalAllow = 'conditionalAllow'
    notAllow = 'notAllow'


class Permission(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    operation: Annotated[
        Optional[resourceDescriptor.Operation],
        Field(None, description='Operation names related to the `resource`.'),
    ]
    access: Annotated[
        Optional[Access],
        Field(
            None,
            description='Access decided after evaluating rules in a policy. Note the access is defined in the order of precedence.',
        ),
    ]
    rule: Annotated[
        Optional[rule.Rule],
        Field(
            None,
            description="Rule that matches the resource and the operation that decided the `access` as `allow` or `deny`. When no rule matches, the `access` is set to `notAllow`. When access can't be determined because all information required to match the `condition` in the rule, `access` is set to `conditional`.",
        ),
    ]
    policy: Annotated[
        Optional[str],
        Field(None, description='Name of the policy where the `rule` is from.'),
    ]
    role: Annotated[
        Optional[str],
        Field(
            None,
            description='Name of the role where the `policy` is from. If this is not role based policy, `role` is set to null',
        ),
    ]


class ResourcePermission(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    resource: Annotated[str, Field(description='Name of the resource')]
    permissions: Annotated[
        List[Permission], Field(description='Permissions for a `resource`.')
    ]
