# generated by datamodel-codegen:
#   filename:  entity/policies/policy.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from typing import List, Optional

from pydantic import ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from ...type import basic, entityHistory, entityReference, entityReferenceList
from .accessControl import rule


class Rules(RootModel[List[rule.Rule]]):
    root: Annotated[
        List[rule.Rule], Field(description='A set of rules associated with the Policy.')
    ]


class Policy(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    id: Annotated[
        basic.Uuid, Field(description='Unique identifier that identifies this Policy.')
    ]
    name: Annotated[
        basic.EntityName,
        Field(description='Name that uniquely identifies this Policy.'),
    ]
    fullyQualifiedName: Annotated[
        Optional[basic.EntityName],
        Field(None, description='Name that uniquely identifies a Policy.'),
    ]
    displayName: Annotated[
        Optional[str], Field(None, description='Display name for this Policy.')
    ]
    description: Annotated[
        Optional[basic.Markdown],
        Field(
            None,
            description='A short description of the Policy, comprehensible to regular users.',
        ),
    ]
    owners: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Owners of this Policy.'),
    ]
    href: Annotated[
        Optional[basic.Href],
        Field(None, description='Link to the resource corresponding to this entity.'),
    ]
    enabled: Annotated[
        Optional[bool], Field(True, description='Is the policy enabled.')
    ]
    version: Annotated[
        Optional[entityHistory.EntityVersion],
        Field(None, description='Metadata version of the Policy.'),
    ]
    updatedAt: Annotated[
        Optional[basic.Timestamp],
        Field(
            None,
            description='Last update time corresponding to the new version of the Policy in Unix epoch time milliseconds.',
        ),
    ]
    updatedBy: Annotated[
        Optional[str], Field(None, description='User who made the update.')
    ]
    changeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that led to this version of the Policy.'),
    ]
    incrementalChangeDescription: Annotated[
        Optional[entityHistory.ChangeDescription],
        Field(None, description='Change that lead to this version of the entity.'),
    ]
    rules: Annotated[Rules, Field(description='Set of rules that the policy contains.')]
    teams: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Teams that use this policy directly and not through roles.',
        ),
    ]
    roles: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(None, description='Roles that use this policy.'),
    ]
    location: Annotated[
        Optional[entityReference.EntityReference],
        Field(
            None,
            description='Location to which a policy is applied. This field is relevant only for `lifeCycle` policies.',
        ),
    ]
    allowDelete: Annotated[
        Optional[bool], Field(None, description="Some system policies can't be deleted")
    ]
    allowEdit: Annotated[
        Optional[bool], Field(None, description="Some system roles can't be edited")
    ]
    deleted: Annotated[
        Optional[bool],
        Field(
            False, description='When `true` indicates the entity has been soft deleted.'
        ),
    ]
    provider: Optional[basic.ProviderType] = basic.ProviderType.user
    disabled: Annotated[
        Optional[bool],
        Field(
            None,
            description="System policy can't be deleted. Use this flag to disable them.",
        ),
    ]
    domains: Annotated[
        Optional[entityReferenceList.EntityReferenceList],
        Field(
            None,
            description='Domains the asset belongs to. When not set, the asset inherits the domain from the parent it belongs to.',
        ),
    ]
