# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/lookerConnection.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....security.credentials import (
    bitbucketCredentials,
    githubCredentials,
    gitlabCredentials,
)
from .....type import filterPattern
from .. import connectionBasicType


class LookerType(Enum):
    Looker = 'Looker'


class NoGitCredentials(BaseModel):
    pass
    model_config = ConfigDict(
        extra='forbid',
    )


class LookerConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[LookerType],
        Field(LookerType.Looker, description='Service Type', title='Service Type'),
    ]
    clientId: Annotated[
        str,
        Field(
            description="User's Client ID. This user should have privileges to read all the metadata in Looker.",
            title='Client ID',
        ),
    ]
    clientSecret: Annotated[
        CustomSecretStr,
        Field(description="User's Client Secret.", title='Client Secret'),
    ]
    hostPort: Annotated[
        AnyUrl, Field(description='URL to the Looker instance.', title='Host and Port')
    ]
    gitCredentials: Annotated[
        Optional[
            Union[
                NoGitCredentials,
                githubCredentials.GitHubCredentials,
                bitbucketCredentials.BitBucketCredentials,
                gitlabCredentials.GitlabCredentials,
            ]
        ],
        Field(
            None,
            description='Credentials to extract the .lkml files from a repository. This is required to get all the lineage and definitions.',
            title='GitHub Credentials',
        ),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Default Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Default Project Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
