# generated by datamodel-codegen:
#   filename:  entity/services/connections/dashboard/redashConnection.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class RedashType(Enum):
    Redash = 'Redash'


class RedashConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[RedashType],
        Field(RedashType.Redash, description='Service Type', title='Service Type'),
    ]
    username: Annotated[str, Field(description='Username for Redash', title='Username')]
    hostPort: Annotated[
        AnyUrl, Field(description='URL for the Redash instance', title='Host and Port')
    ]
    apiKey: Annotated[
        CustomSecretStr,
        Field(description='API key of the redash instance to access.', title='API Key'),
    ]
    redashVersion: Annotated[
        Optional[str],
        Field(
            '10.0.0',
            description='Version of the Redash instance',
            title='Redash Version',
        ),
    ]
    dashboardFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include dashboards that matches the pattern.',
            title='Default Dashboard Filter Pattern',
        ),
    ]
    chartFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include charts that matches the pattern.',
            title='Default Chart Filter Pattern',
        ),
    ]
    dataModelFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude or include data models that matches the pattern.',
            title='Default Data Model Filter Pattern',
        ),
    ]
    projectFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to exclude or include projects that matches the pattern.',
            title='Default Project Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
