# generated by datamodel-codegen:
#   filename:  entity/services/connections/database/exasolConnection.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel, CustomSecretStr

from .....type import filterPattern
from .. import connectionBasicType


class Tls(Enum):
    disable_tls = 'disable-tls'
    ignore_certificate = 'ignore-certificate'
    validate_certificate = 'validate-certificate'


class ExasolType(Enum):
    Exasol = 'Exasol'


class ExasolScheme(Enum):
    exa_websocket = 'exa+websocket'


class ExasolConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[ExasolType],
        Field(ExasolType.Exasol, description='Service Type', title='Service Type'),
    ]
    scheme: Annotated[
        Optional[ExasolScheme],
        Field(
            ExasolScheme.exa_websocket,
            description='SQLAlchemy driver scheme options.',
            title='Connection Scheme',
        ),
    ]
    username: Annotated[
        str,
        Field(
            description='Username to connect to Exasol. This user should have privileges to read all the metadata in Exasol.',
            title='Username',
        ),
    ]
    password: Annotated[
        CustomSecretStr,
        Field(description='Password to connect to Exasol.', title='Password'),
    ]
    hostPort: Annotated[
        str,
        Field(
            description='Host and port of the source service.', title='Host and Port'
        ),
    ]
    tls: Annotated[
        Optional[Tls],
        Field(
            Tls.validate_certificate,
            description='Client SSL/TLS settings.',
            title='SSL/TLS Settings',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
    supportsLineageExtraction: Optional[
        connectionBasicType.SupportsLineageExtraction
    ] = None
