# generated by datamodel-codegen:
#   filename:  entity/services/connections/drive/googleDriveConnection.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import gcpCredentials
from .. import connectionBasicType


class GoogleDriveType(Enum):
    GoogleDrive = 'GoogleDrive'


class GoogleDriveConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[GoogleDriveType],
        Field(
            GoogleDriveType.GoogleDrive,
            description='Service Type',
            title='Service Type',
        ),
    ]
    credentials: Annotated[
        gcpCredentials.GCPCredentials,
        Field(
            description='GCP Credentials for Google Drive API', title='GCP Credentials'
        ),
    ]
    delegatedEmail: Annotated[
        Optional[str],
        Field(
            None,
            description='Email to impersonate using domain-wide delegation',
            title='Delegated Email',
        ),
    ]
    driveId: Annotated[
        Optional[str],
        Field(
            None, description='Specific shared drive ID to connect to', title='Drive ID'
        ),
    ]
    includeTeamDrives: Annotated[
        Optional[bool],
        Field(
            True,
            description='Include shared/team drives in metadata extraction',
            title='Include Team Drives',
        ),
    ]
    includeGoogleSheets: Annotated[
        Optional[bool],
        Field(
            False,
            description='Extract metadata only for Google Sheets files',
            title='Include Google Sheets',
        ),
    ]
    connectionOptions: Annotated[
        Optional[connectionBasicType.ConnectionOptions],
        Field(None, title='Connection Options'),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
