# generated by datamodel-codegen:
#   filename:  entity/services/connections/metadata/alationSinkConnection.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Dict, Optional, Union

from pydantic import AnyUrl, ConfigDict, Field, RootModel
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....security.credentials import apiAccessTokenAuth, basicAuth
from .....security.ssl import verifySSLConfig
from .....type import filterPattern
from .. import connectionBasicType


class AlationSinkType(Enum):
    AlationSink = 'AlationSink'


class DatasourceLinks(RootModel[Optional[Dict[str, str]]]):
    root: Optional[Dict[str, str]] = None


class AlationSinkConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[AlationSinkType],
        Field(AlationSinkType.AlationSink, description='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Host and port of the Alation service.', title='Host and Port'
        ),
    ]
    authType: Annotated[
        Union[basicAuth.BasicAuth, apiAccessTokenAuth.ApiAccessTokenAuth],
        Field(
            description='Types of methods used to authenticate to the alation instance',
            title='Authentication type for Alation',
        ),
    ]
    projectName: Annotated[
        Optional[str],
        Field(
            'AlationAPI',
            description='Project name to create the refreshToken. Can be anything',
            title='Project Name',
        ),
    ]
    paginationLimit: Annotated[
        Optional[int],
        Field(
            10,
            description='Pagination limit used for Alation APIs pagination',
            title='Pagination Limit',
        ),
    ]
    datasourceLinks: Optional[DatasourceLinks] = None
    verifySSL: Optional[verifySSLConfig.VerifySSL] = verifySSLConfig.VerifySSL.no_ssl
    sslConfig: Optional[verifySSLConfig.SslConfig] = None
    connectionOptions: Optional[connectionBasicType.ConnectionOptions] = None
    connectionArguments: Optional[connectionBasicType.ConnectionArguments] = None
    schemaFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude schemas that matches the pattern.',
            title='Default Schema Filter Pattern',
        ),
    ]
    tableFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude tables that matches the pattern.',
            title='Default Table Filter Pattern',
        ),
    ]
    databaseFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only include/exclude databases that matches the pattern.',
            title='Default Database Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Optional[
        connectionBasicType.SupportsMetadataExtraction
    ] = None
