# generated by datamodel-codegen:
#   filename:  entity/services/connections/pipeline/splineConnection.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....type import filterPattern
from .. import connectionBasicType


class SplineType(Enum):
    Spline = 'Spline'


class SplineConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[SplineType],
        Field(SplineType.Spline, description='Service Type', title='Service Type'),
    ]
    hostPort: Annotated[
        AnyUrl,
        Field(
            description='Spline REST Server Host & Port.',
            title='Spline REST Server Host & Port',
        ),
    ]
    uiHostPort: Annotated[
        Optional[AnyUrl],
        Field(
            None, description='Spline UI Host & Port.', title='Spline UI Host & Port'
        ),
    ]
    pipelineFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex exclude pipelines.',
            title='Default Pipeline Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
