# generated by datamodel-codegen:
#   filename:  entity/services/connections/search/elasticSearchConnection.json
#   timestamp: 2025-08-31T05:38:48+00:00

from __future__ import annotations

from enum import Enum
from typing import Optional, Union

from pydantic import AnyUrl, ConfigDict, Field
from typing_extensions import Annotated

from metadata.ingestion.models.custom_pydantic import BaseModel

from .....type import filterPattern
from .. import connectionBasicType
from ..common import sslConfig
from .elasticSearch import apiAuth, basicAuth


class ElasticSearchType(Enum):
    ElasticSearch = 'ElasticSearch'


class ElasticsearchConnection(BaseModel):
    model_config = ConfigDict(
        extra='forbid',
    )
    type: Annotated[
        Optional[ElasticSearchType],
        Field(
            ElasticSearchType.ElasticSearch,
            description='ElasticSearch Type',
            title='ElasticSearch Type',
        ),
    ]
    hostPort: Annotated[
        Optional[AnyUrl],
        Field(
            None,
            description='Host and port of the ElasticSearch service.',
            title='Host and Port',
        ),
    ]
    authType: Annotated[
        Optional[Union[basicAuth.BasicAuthentication, apiAuth.ApiKeyAuthentication]],
        Field(
            None,
            description='Choose Auth Config Type.',
            title='Auth Configuration Type',
        ),
    ]
    sslConfig: Annotated[Optional[sslConfig.SslConfig], Field(None, title='SSL Config')]
    connectionTimeoutSecs: Annotated[
        Optional[int],
        Field(
            30,
            description='Connection Timeout in Seconds',
            title='Connection Timeout in Seconds',
        ),
    ]
    connectionArguments: Annotated[
        Optional[connectionBasicType.ConnectionArguments],
        Field(None, title='Connection Arguments'),
    ]
    searchIndexFilterPattern: Annotated[
        Optional[filterPattern.FilterPattern],
        Field(
            None,
            description='Regex to only fetch search indexes that matches the pattern.',
            title='Default Search Index Filter Pattern',
        ),
    ]
    supportsMetadataExtraction: Annotated[
        Optional[connectionBasicType.SupportsMetadataExtraction],
        Field(None, title='Supports Metadata Extraction'),
    ]
